/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayRemove$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(array, element) - Remove all elements that equal to element from array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, null, 3), 3);\n       [1,2,null]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001\u0002\u0011\"\u0001:B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0011\"AA\n\u0001BK\u0002\u0013\u0005q\t\u0003\u0005N\u0001\tE\t\u0015!\u0003I\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015\u0019\b\u0001\"\u0003U\u0011!!\b\u0001#b\u0001\n\u0013)\bbBA\u0001\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003\u001b\u0001A\u0011IA\b\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!!\u0014\u0001\t\u0003\ny\u0005C\u0004\u0002R\u0001!\t&a\u0015\t\u0013\u0005u\u0003!!A\u0005\u0002\u0005}\u0003\"CA3\u0001E\u0005I\u0011AA4\u0011%\ti\bAI\u0001\n\u0003\t9\u0007C\u0005\u0002\u0000\u0001\t\t\u0011\"\u0011\u0002\u0002\"I\u0011\u0011\u0013\u0001\u0002\u0002\u0013\u0005\u00111\u0013\u0005\n\u00037\u0003\u0011\u0011!C\u0001\u0003;C\u0011\"a)\u0001\u0003\u0003%\t%!*\t\u0013\u0005M\u0006!!A\u0005\u0002\u0005U\u0006\"CA`\u0001\u0005\u0005I\u0011IAa\u000f%\t)/IA\u0001\u0012\u0003\t9O\u0002\u0005!C\u0005\u0005\t\u0012AAu\u0011\u0019q%\u0004\"\u0001\u0002x\"I\u0011\u0011 \u000e\u0002\u0002\u0013\u0015\u00131 \u0005\n\u0003{T\u0012\u0011!CA\u0003\u007fD\u0011B!\u0002\u001b\u0003\u0003%\tIa\u0002\t\u0013\te!$!A\u0005\n\tm!aC!se\u0006L(+Z7pm\u0016T!AI\u0012\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003I\u0015\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003M\u001d\n1a]9m\u0015\tA\u0013&A\u0003ta\u0006\u00148N\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<7\u0001A\n\u0007\u0001=\u001ad'P\"\u0011\u0005A\nT\"A\u0011\n\u0005I\n#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\u0001D'\u0003\u00026C\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00028u9\u0011\u0001\u0007O\u0005\u0003s\u0005\nq\u0001]1dW\u0006<W-\u0003\u0002<y\tqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA\u001d\"!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0010#\n\u0005\u0015{$\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00027fMR,\u0012\u0001\u0013\t\u0003a%K!AS\u0011\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007A\u000b&\u000b\u0005\u00021\u0001!)a)\u0002a\u0001\u0011\")A*\u0002a\u0001\u0011\u0006AA-\u0019;b)f\u0004X-F\u0001V!\t1\u0016,D\u0001X\u0015\tAV%A\u0003usB,7/\u0003\u0002[/\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0018\t\u0004=\u0016DgBA0e\u001d\t\u00017-D\u0001b\u0015\t\u0011W&\u0001\u0004=e>|GOP\u0005\u0002\u0001&\u0011\u0011hP\u0005\u0003M\u001e\u00141aU3r\u0015\tIt\b\u0005\u0002WS&\u0011!n\u0016\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012!\u001c\t\u0003]Fl\u0011a\u001c\u0006\u0003a\u000e\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003e>\u0014q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\fK2,W.\u001a8u)f\u0004X-\u0001\u0005pe\u0012,'/\u001b8h+\u00051\bc\u00010xs&\u0011\u0001p\u001a\u0002\t\u001fJ$WM]5oOB\u0011aH_\u0005\u0003w~\u00121!\u00118zQ\tQQ\u0010\u0005\u0002?}&\u0011qp\u0010\u0002\niJ\fgn]5f]R\fAB\\;mYN\u000bg-Z#wC2$R!_A\u0003\u0003\u0013Aa!a\u0002\f\u0001\u0004I\u0018aA1se\"1\u00111B\u0006A\u0002e\fQA^1mk\u0016\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005E\u0011QDA\u0014!\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!bAA\fC\u000591m\u001c3fO\u0016t\u0017\u0002BA\u000e\u0003+\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003?a\u0001\u0019AA\u0011\u0003\r\u0019G\u000f\u001f\t\u0005\u0003'\t\u0019#\u0003\u0003\u0002&\u0005U!AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003Sa\u0001\u0019AA\t\u0003\t)g/\u0001\thK:\u001cu\u000eZ3G_J\u0014Vm];miRa\u0011qFA \u0003\u0003\n\u0019%a\u0012\u0002JA!\u0011\u0011GA\u001d\u001d\u0011\t\u0019$!\u000e\u0011\u0005\u0001|\u0014bAA\u001c\u007f\u00051\u0001K]3eK\u001aLA!a\u000f\u0002>\t11\u000b\u001e:j]\u001eT1!a\u000e@\u0011\u001d\ty\"\u0004a\u0001\u0003CAq!!\u000b\u000e\u0001\u0004\t\t\u0002C\u0004\u0002F5\u0001\r!a\f\u0002\u0015%t\u0007/\u001e;BeJ\f\u0017\u0010C\u0004\u0002\f5\u0001\r!a\f\t\u000f\u0005-S\u00021\u0001\u00020\u0005aa.Z<BeJ\f\u0017pU5{K\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005=\u0012aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015\u0001\u0016QKA-\u0011\u0019\t9f\u0004a\u0001\u0011\u00069a.Z<MK\u001a$\bBBA.\u001f\u0001\u0007\u0001*\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u000bA\u000b\t'a\u0019\t\u000f\u0019\u0003\u0002\u0013!a\u0001\u0011\"9A\n\u0005I\u0001\u0002\u0004A\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003SR3\u0001SA6W\t\ti\u0007\u0005\u0003\u0002p\u0005eTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAA<\u007f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0014\u0011\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\u0005\u0003BAC\u0003\u001fk!!a\"\u000b\t\u0005%\u00151R\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u000e\u0006!!.\u0019<b\u0013\u0011\tY$a\"\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005U\u0005c\u0001 \u0002\u0018&\u0019\u0011\u0011T \u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007e\fy\nC\u0005\u0002\"V\t\t\u00111\u0001\u0002\u0016\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a*\u0011\u000b\u0005%\u0016qV=\u000e\u0005\u0005-&bAAW\u007f\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u00161\u0016\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00028\u0006u\u0006c\u0001 \u0002:&\u0019\u00111X \u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011U\f\u0002\u0002\u0003\u0007\u00110\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003o\u000b\u0019\r\u0003\u0005\u0002\"b\t\t\u00111\u0001zQM\u0001\u0011qYAg\u0003\u001f\f\u0019.!6\u0002Z\u0006m\u0017q\\Aq!\r\u0001\u0014\u0011Z\u0005\u0004\u0003\u0017\f#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003#\faj\u0018$V\u001d\u000e{\u0006&\u0019:sCfd\u0003%\u001a7f[\u0016tG/\u000b\u0011.AI+Wn\u001c<fA\u0005dG\u000eI3mK6,g\u000e^:!i\"\fG\u000fI3rk\u0006d\u0007\u0005^8!K2,W.\u001a8uA\u0019\u0014x.\u001c\u0011beJ\f\u0017PL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011q[\u0001W\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQEb\u0003E\r\u0017!g1\u0002c.\u001e7mY\u0001\u001a\u0014\u0006\f\u00114SmR\u0001\u0005\t\u0011!A\u0001\u00023,\r\u00173Y9,H\u000e\\/\u000bA\u0001\nQa\u001a:pkB\f#!!8\u0002\u0017\u0005\u0014(/Y=`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003G\fQA\r\u00185]A\n1\"\u0011:sCf\u0014V-\\8wKB\u0011\u0001GG\n\u00055\u0005-8\tE\u0004\u0002n\u0006M\b\n\u0013)\u000e\u0005\u0005=(bAAy\u007f\u00059!/\u001e8uS6,\u0017\u0002BA{\u0003_\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\t9/\u0001\u0005u_N#(/\u001b8h)\t\t\u0019)A\u0003baBd\u0017\u0010F\u0003Q\u0005\u0003\u0011\u0019\u0001C\u0003G;\u0001\u0007\u0001\nC\u0003M;\u0001\u0007\u0001*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t%!Q\u0003\t\u0006}\t-!qB\u0005\u0004\u0005\u001by$AB(qi&|g\u000eE\u0003?\u0005#A\u0005*C\u0002\u0003\u0014}\u0012a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B\f=\u0005\u0005\t\u0019\u0001)\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u000f!\u0011\t)Ia\b\n\t\t\u0005\u0012q\u0011\u0002\u0007\u001f\nTWm\u0019;")
public class ArrayRemove
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient Ordering<Object> ordering;
    private final Expression left;
    private final Expression right;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayRemove arrayRemove) {
        return ArrayRemove$.MODULE$.unapply(arrayRemove);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayRemove> tupled() {
        return ArrayRemove$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayRemove>> curried() {
        return ArrayRemove$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Seq seq;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return (Seq)Nil$.MODULE$;
        DataType dataType = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType instanceof ArrayType)) return (Seq)Nil$.MODULE$;
        ArrayType arrayType = (ArrayType)dataType;
        DataType e1 = arrayType.elementType();
        boolean hasNull = arrayType.containsNull();
        Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e2);
        if (option instanceof Some) {
            Some some = (Some)option;
            DataType dt = (DataType)some.value();
            seq = (Seq)new .colon.colon((Object)new ArrayType(dt, hasNull), (List)new .colon.colon((Object)dt, (List)Nil$.MODULE$));
            return seq;
        } else {
            seq = (Seq)Nil$.MODULE$;
        }
        return seq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(95).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
        DataType dataType = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType instanceof ArrayType)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(95).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
        ArrayType arrayType = (ArrayType)dataType;
        DataType e1 = arrayType.elementType();
        if (!e1.sameType(e2)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(95).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
        return TypeUtils$.MODULE$.checkForOrderingExpr(e2, new StringBuilder(9).append("function ").append(this.prettyName()).toString());
    }

    private DataType elementType() {
        return ((ArrayType)this.left().dataType()).elementType();
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayRemove arrayRemove = this;
        synchronized (arrayRemove) {
            if (!this.bitmap$trans$0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.right().dataType());
                this.bitmap$trans$0 = true;
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return !this.bitmap$trans$0 ? this.ordering$lzycompute() : this.ordering;
    }

    @Override
    public Object nullSafeEval(Object arr, Object value) {
        Object[] newArray = new Object[((ArrayData)arr).numElements()];
        IntRef pos = IntRef.create((int)0);
        ((ArrayData)arr).foreach(this.right().dataType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(i, v) -> {
            ArrayRemove.$anonfun$nullSafeEval$8(this, value, newArray, pos, BoxesRunTime.unboxToInt((Object)i), v);
            return BoxedUnit.UNIT;
        });
        return new GenericArrayData((Object[])Predef$.MODULE$.genericArrayOps((Object)newArray).slice(0, pos.elem));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(arr, value) -> {
            String numsToRemove = ctx.freshName("numsToRemove");
            String newArraySize = ctx.freshName("newArraySize");
            String i = ctx.freshName("i");
            String getValue = CodeGenerator$.MODULE$.getValue((String)arr, this.elementType(), i);
            String isEqual = ctx.genEqual(this.elementType(), (String)value, getValue);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(211).append("\n         |int ").append(numsToRemove).append(" = 0;\n         |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)arr).append(".numElements(); ").append(i).append(" ++) {\n         |  if (!").append((String)arr).append(".isNullAt(").append(i).append(") && ").append(isEqual).append(") {\n         |    ").append(numsToRemove).append(" = ").append(numsToRemove).append(" + 1;\n         |  }\n         |}\n         |int ").append(newArraySize).append(" = ").append((String)arr).append(".numElements() - ").append(numsToRemove).append(";\n         |").append(this.genCodeForResult(ctx, ev, (String)arr, (String)value, newArraySize)).append("\n       ").toString())).stripMargin();
        });
    }

    public String genCodeForResult(CodegenContext ctx, ExprCode ev, String inputArray, String value, String newArraySize) {
        String values = ctx.freshName("values");
        String i = ctx.freshName("i");
        String pos = ctx.freshName("pos");
        String getValue = CodeGenerator$.MODULE$.getValue(inputArray, this.elementType(), i);
        String isEqual = ctx.genEqual(this.elementType(), value, getValue);
        String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), newArraySize, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), inputArray, pos, i, false);
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(297).append("\n       |").append(allocation).append("\n       |int ").append(pos).append(" = 0;\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(inputArray).append(".numElements(); ").append(i).append(" ++) {\n       |  if (").append(inputArray).append(".isNullAt(").append(i).append(")) {\n       |    ").append(values).append(".setNullAt(").append(pos).append(");\n       |    ").append(pos).append(" = ").append(pos).append(" + 1;\n       |  }\n       |  else {\n       |    if (!(").append(isEqual).append(")) {\n       |      ").append(assignment).append("\n       |      ").append(pos).append(" = ").append(pos).append(" + 1;\n       |    }\n       |  }\n       |}\n       |").append(ev.value()).append(" = ").append(values).append(";\n     ").toString())).stripMargin();
    }

    @Override
    public String prettyName() {
        return "array_remove";
    }

    @Override
    public ArrayRemove withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArrayRemove copy(Expression left, Expression right) {
        return new ArrayRemove(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayRemove";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayRemove;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayRemove)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayRemove arrayRemove = (ArrayRemove)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayRemove.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayRemove.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayRemove.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$8(ArrayRemove $this, Object value$3, Object[] newArray$1, IntRef pos$1, int i, Object v) {
        block0: {
            if (v != null && $this.ordering().equiv(v, value$3)) break block0;
            newArray$1[pos$1.elem] = v;
            ++pos$1.elem;
        }
    }

    public ArrayRemove(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

