/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ToNumberBase;
import org.apache.spark.sql.catalyst.expressions.TryToNumber$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n     _FUNC_(expr, fmt) - Convert string 'expr' to a number based on the string format `fmt`.\n       Returns NULL if the string 'expr' does not match the expected format. The format follows the\n       same semantics as the to_number function.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('454', '999');\n       454\n      > SELECT _FUNC_('454.00', '000.00');\n       454.00\n      > SELECT _FUNC_('12,454', '99,999');\n       12454\n      > SELECT _FUNC_('$78.12', '$99.99');\n       78.12\n      > SELECT _FUNC_('12,454.8-', '99,999.9S');\n       -12454.8\n  ", since="3.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\r\u001b\u0001\u001eB\u0001\"\u000e\u0001\u0003\u0016\u0004%\tA\u000e\u0005\tu\u0001\u0011\t\u0012)A\u0005o!A1\b\u0001BK\u0002\u0013\u0005a\u0007\u0003\u0005=\u0001\tE\t\u0015!\u00038\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015\u0011\u0005\u0001\"\u0011D\u0011\u00159\u0005\u0001\"\u0011I\u0011\u0015!\u0006\u0001\"\u0015V\u0011\u001dQ\u0006!!A\u0005\u0002mCqA\u0018\u0001\u0012\u0002\u0013\u0005q\fC\u0004k\u0001E\u0005I\u0011A0\t\u000f-\u0004\u0011\u0011!C!Y\"9A\u000fAA\u0001\n\u0003)\bbB=\u0001\u0003\u0003%\tA\u001f\u0005\n\u0003\u0003\u0001\u0011\u0011!C!\u0003\u0007A\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005]\u0001!!A\u0005B\u0005eq!CA\u001f5\u0005\u0005\t\u0012AA \r!I\"$!A\t\u0002\u0005\u0005\u0003BB\u001f\u0014\t\u0003\ty\u0005C\u0005\u0002RM\t\t\u0011\"\u0012\u0002T!I\u0011QK\n\u0002\u0002\u0013\u0005\u0015q\u000b\u0005\n\u0003;\u001a\u0012\u0011!CA\u0003?B\u0011\"!\u001d\u0014\u0003\u0003%I!a\u001d\u0003\u0017Q\u0013\u0018\u0010V8Ok6\u0014WM\u001d\u0006\u00037q\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QDH\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0004I\u0001\u0004gFd'BA\u0011#\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u000b\u00173!\tI#&D\u0001\u001b\u0013\tY#D\u0001\u0007U_:+XNY3s\u0005\u0006\u001cX\r\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdFA\u0004Qe>$Wo\u0019;\u0011\u00055\u001a\u0014B\u0001\u001b/\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003]\u0002\"!\u000b\u001d\n\u0005eR\"AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDcA A\u0003B\u0011\u0011\u0006\u0001\u0005\u0006k\u0015\u0001\ra\u000e\u0005\u0006w\u0015\u0001\raN\u0001\t]VdG.\u00192mKV\tA\t\u0005\u0002.\u000b&\u0011aI\f\u0002\b\u0005>|G.Z1o\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002\u0013B\u0011!*\u0015\b\u0003\u0017>\u0003\"\u0001\u0014\u0018\u000e\u00035S!A\u0014\u0014\u0002\rq\u0012xn\u001c;?\u0013\t\u0001f&\u0001\u0004Qe\u0016$WMZ\u0005\u0003%N\u0013aa\u0015;sS:<'B\u0001)/\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002@-bCQa\u0016\u0005A\u0002]\nqA\\3x\u0019\u00164G\u000fC\u0003Z\u0011\u0001\u0007q'\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u0007}bV\fC\u00046\u0013A\u0005\t\u0019A\u001c\t\u000fmJ\u0001\u0013!a\u0001o\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u00011+\u0005]\n7&\u00012\u0011\u0005\rDW\"\u00013\u000b\u0005\u00154\u0017!C;oG\",7m[3e\u0015\t9g&\u0001\u0006b]:|G/\u0019;j_:L!!\u001b3\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005i\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003\u0011a\u0017M\\4\u000b\u0003I\fAA[1wC&\u0011!k\\\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002mB\u0011Qf^\u0005\u0003q:\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$\"a\u001f@\u0011\u00055b\u0018BA?/\u0005\r\te.\u001f\u0005\b\u007f:\t\t\u00111\u0001w\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0001\t\u0006\u0003\u000f\tia_\u0007\u0003\u0003\u0013Q1!a\u0003/\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001f\tIA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001#\u0002\u0016!9q\u0010EA\u0001\u0002\u0004Y\u0018AB3rk\u0006d7\u000fF\u0002E\u00037Aqa`\t\u0002\u0002\u0003\u00071\u0010K\n\u0001\u0003?\t)#a\n\u0002,\u00055\u0012\u0011GA\u001a\u0003o\tI\u0004E\u0002*\u0003CI1!a\t\u001b\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u000b\u0002\u0003WT\u0001\u0005\t\u0011!A}3UKT\"`Q\u0015D\bO\u001d\u0017!M6$\u0018\u0006I\u0017!\u0007>tg/\u001a:uAM$(/\u001b8hA\u001d*\u0007\u0010\u001d:(AQ|\u0007%\u0019\u0011ok6\u0014WM\u001d\u0011cCN,G\rI8oAQDW\rI:ue&tw\r\t4pe6\fG\u000f\t1g[R\u0004gF\u0003\u0011!A\u0001\u0002\u0003\u0005\t*fiV\u0014hn\u001d\u0011O+2c\u0005%\u001b4!i\",\u0007e\u001d;sS:<\u0007eJ3yaJ<\u0003\u0005Z8fg\u0002rw\u000e\u001e\u0011nCR\u001c\u0007\u000e\t;iK\u0002*\u0007\u0010]3di\u0016$\u0007EZ8s[\u0006$h\u0006\t+iK\u00022wN]7bi\u00022w\u000e\u001c7poN\u0004C\u000f[3\u000bA\u0001\u0002\u0003\u0005\t\u0011!g\u0006lW\rI:f[\u0006tG/[2tA\u0005\u001c\b\u0005\u001e5fAQ|wL\\;nE\u0016\u0014\bEZ;oGRLwN\u001c\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003_\t!q\u000b\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OQ*Dg\n\u0017!OeJ\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ*DG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(iU\"d\u0006\r\u0019(Y\u0001:\u0003\u0007\r\u0019/aA:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00115kQr\u0003\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OE\u0012D\u0006N\u001b5O1\u0002s%O\u001d-seJt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cI\"T\u0007\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\u0011:\u0004HL\u00193O1\u0002s\u0005J\u001d:]eJt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!oar\u0013G\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OE\u0012D\u0006N\u001b5]ajs\u0005\f\u0011(seb\u0013(O\u001d/sM;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011.cI\"T\u0007\u000e\u00189\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA\u001b\u0003\u0015\u0019df\r\u00181\u0003\u00159'o\\;qC\t\tY$\u0001\u0007tiJLgnZ0gk:\u001c7/A\u0006Uef$vNT;nE\u0016\u0014\bCA\u0015\u0014'\u0011\u0019\u00121\t\u001a\u0011\u000f\u0005\u0015\u00131J\u001c8\u007f5\u0011\u0011q\t\u0006\u0004\u0003\u0013r\u0013a\u0002:v]RLW.Z\u0005\u0005\u0003\u001b\n9EA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!a\u0010\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\\\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u007f\u0005e\u00131\f\u0005\u0006kY\u0001\ra\u000e\u0005\u0006wY\u0001\raN\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t'!\u001c\u0011\u000b5\n\u0019'a\u001a\n\u0007\u0005\u0015dF\u0001\u0004PaRLwN\u001c\t\u0006[\u0005%tgN\u0005\u0004\u0003Wr#A\u0002+va2,'\u0007\u0003\u0005\u0002p]\t\t\u00111\u0001@\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002vA\u0019a.a\u001e\n\u0007\u0005etN\u0001\u0004PE*,7\r\u001e")
public class TryToNumber
extends ToNumberBase {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(TryToNumber tryToNumber) {
        return TryToNumber$.MODULE$.unapply(tryToNumber);
    }

    public static Function1<Tuple2<Expression, Expression>, TryToNumber> tupled() {
        return TryToNumber$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, TryToNumber>> curried() {
        return TryToNumber$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "try_to_number";
    }

    @Override
    public TryToNumber withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public TryToNumber copy(Expression left, Expression right) {
        return new TryToNumber(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "TryToNumber";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TryToNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TryToNumber)) return false;
        boolean bl = true;
        if (!bl) return false;
        TryToNumber tryToNumber = (TryToNumber)x$1;
        Expression expression = this.left();
        Expression expression2 = tryToNumber.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = tryToNumber.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!tryToNumber.canEqual(this)) return false;
        return true;
    }

    public TryToNumber(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        super(left, right, false);
    }
}

