/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.util.Map;
import org.apache.iceberg.util.PropertyUtil;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.s3accessgrants.plugin.S3AccessGrantsPlugin;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

class S3AccessGrantsPluginConfigurations {
    private boolean isS3AccessGrantsFallbackToIamEnabled;

    private S3AccessGrantsPluginConfigurations() {
    }

    public <T extends S3ClientBuilder> void configureS3ClientBuilder(T builder) {
        S3AccessGrantsPlugin s3AccessGrantsPlugin = (S3AccessGrantsPlugin)S3AccessGrantsPlugin.builder().enableFallback(Boolean.valueOf(this.isS3AccessGrantsFallbackToIamEnabled)).build();
        builder.addPlugin((SdkPlugin)s3AccessGrantsPlugin);
    }

    private void initialize(Map<String, String> properties) {
        this.isS3AccessGrantsFallbackToIamEnabled = PropertyUtil.propertyAsBoolean(properties, (String)"s3.access-grants.fallback-to-iam", (boolean)false);
    }

    public static S3AccessGrantsPluginConfigurations create(Map<String, String> properties) {
        S3AccessGrantsPluginConfigurations configurations = new S3AccessGrantsPluginConfigurations();
        configurations.initialize(properties);
        return configurations;
    }
}

