/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelOption;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollMode;
import io.netty.handler.ssl.SslContext;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.bifromq.mqtt.MQTTBrokerBuilder;

public abstract class ConnListenerBuilder<C extends ConnListenerBuilder<C>> {
    protected final Map<ChannelOption<?>, Object> options = new LinkedHashMap();
    protected final Map<ChannelOption<?>, Object> childOptions = new LinkedHashMap();
    private final MQTTBrokerBuilder serverBuilder;
    protected String host;
    protected int port;

    ConnListenerBuilder(MQTTBrokerBuilder builder) {
        this.serverBuilder = builder;
        this.options.put(ChannelOption.SO_BACKLOG, 128);
        this.options.put(ChannelOption.SO_REUSEADDR, true);
        if (Epoll.isAvailable()) {
            this.options.put(EpollChannelOption.EPOLL_MODE, EpollMode.EDGE_TRIGGERED);
        }
        this.childOptions.put(ChannelOption.SO_KEEPALIVE, true);
    }

    private C thisT() {
        return (C)this;
    }

    public C host(String host) {
        Preconditions.checkArgument((host != null ? 1 : 0) != 0, (Object)"host can't be null");
        this.host = host;
        return this.thisT();
    }

    public C port(int port) {
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"port");
        this.port = port;
        return this.thisT();
    }

    public <T> C option(ChannelOption<T> option, T value) {
        Preconditions.checkNotNull(option, (Object)"option");
        if (value == null) {
            this.options.remove(option);
        } else {
            this.options.put(option, value);
        }
        return this.thisT();
    }

    public <T> C childOption(ChannelOption<T> option, T value) {
        Preconditions.checkNotNull(option, (Object)"option");
        if (value == null) {
            this.childOptions.remove(option);
        } else {
            this.childOptions.put(option, value);
        }
        return this.thisT();
    }

    public MQTTBrokerBuilder buildListener() {
        return this.serverBuilder;
    }

    public static final class WSSConnListenerBuilder
    extends SecuredConnListenerBuilder<WSSConnListenerBuilder> {
        private String path;

        WSSConnListenerBuilder(MQTTBrokerBuilder builder) {
            super(builder);
        }

        public String path() {
            return this.path;
        }

        public WSSConnListenerBuilder path(String path) {
            this.path = path;
            return this;
        }
    }

    public static final class WSConnListenerBuilder
    extends ConnListenerBuilder<WSConnListenerBuilder> {
        private String path = "mqtt";

        WSConnListenerBuilder(MQTTBrokerBuilder builder) {
            super(builder);
        }

        public String path() {
            return this.path;
        }

        public WSConnListenerBuilder path(String path) {
            this.path = path;
            return this;
        }
    }

    public static final class TLSConnListenerBuilder
    extends SecuredConnListenerBuilder<TLSConnListenerBuilder> {
        TLSConnListenerBuilder(MQTTBrokerBuilder builder) {
            super(builder);
            this.port(8883);
        }
    }

    private static abstract class SecuredConnListenerBuilder<L extends SecuredConnListenerBuilder<L>>
    extends ConnListenerBuilder<L> {
        protected SslContext sslContext;

        SecuredConnListenerBuilder(MQTTBrokerBuilder builder) {
            super(builder);
        }

        public L sslContext(@NonNull SslContext sslContext) {
            if (sslContext == null) {
                throw new NullPointerException("sslContext is marked non-null but is null");
            }
            Preconditions.checkArgument((boolean)sslContext.isServer());
            this.sslContext = sslContext;
            return (L)this;
        }
    }

    public static class TCPConnListenerBuilder
    extends ConnListenerBuilder<TCPConnListenerBuilder> {
        TCPConnListenerBuilder(MQTTBrokerBuilder builder) {
            super(builder);
            this.port(1883);
        }
    }
}

