/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.processor;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.pf4j.processor.ExtensionAnnotationProcessor;
import org.pf4j.processor.ExtensionStorage;

public class ServiceProviderExtensionStorage
extends ExtensionStorage {
    public static final String EXTENSIONS_RESOURCE = "META-INF/services";

    public ServiceProviderExtensionStorage(ExtensionAnnotationProcessor processor) {
        super(processor);
    }

    @Override
    public Map<String, Set<String>> read() {
        HashMap<String, Set<String>> extensions = new HashMap<String, Set<String>>();
        for (String extensionPoint : this.processor.getExtensions().keySet()) {
            try {
                FileObject file = this.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + extensionPoint);
                HashSet<String> entries = new HashSet<String>();
                ExtensionStorage.read(file.openReader(true), entries);
                extensions.put(extensionPoint, entries);
            }
            catch (FileNotFoundException | NoSuchFileException file) {
            }
            catch (FilerException file) {
            }
            catch (IOException e) {
                this.error(e.getMessage(), new Object[0]);
            }
        }
        return extensions;
    }

    @Override
    public void write(Map<String, Set<String>> extensions) {
        for (Map.Entry<String, Set<String>> entry : extensions.entrySet()) {
            String extensionPoint = entry.getKey();
            try {
                FileObject file = this.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + extensionPoint, new Element[0]);
                try (BufferedWriter writer = new BufferedWriter(file.openWriter());){
                    writer.write("# Generated by PF4J");
                    writer.newLine();
                    for (String extension : entry.getValue()) {
                        writer.write(extension);
                        if (!this.isExtensionOld(extensionPoint, extension)) {
                            writer.write(" # pf4j extension");
                        }
                        writer.newLine();
                    }
                }
            }
            catch (FileNotFoundException file) {
            }
            catch (FilerException file) {
            }
            catch (IOException e) {
                this.error(e.toString(), new Object[0]);
            }
        }
    }

    private boolean isExtensionOld(String extensionPoint, String extension) {
        return this.processor.getOldExtensions().containsKey(extensionPoint) && this.processor.getOldExtensions().get(extensionPoint).contains(extension);
    }
}

