/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker;

import com.google.common.util.concurrent.MoreExecutors;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.store.api.IKVRangeCoProc;
import org.apache.bifromq.basekv.store.api.IKVRangeCoProcFactory;
import org.apache.bifromq.basekv.store.api.IKVRangeRefreshableReader;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.deliverer.IMessageDeliverer;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.dist.worker.DeliverExecutorGroup;
import org.apache.bifromq.dist.worker.DistWorkerCoProc;
import org.apache.bifromq.dist.worker.ISubscriptionCleaner;
import org.apache.bifromq.dist.worker.SubscriptionCleaner;
import org.apache.bifromq.dist.worker.TenantsStats;
import org.apache.bifromq.dist.worker.cache.SubscriptionCache;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.resourcethrottler.IResourceThrottler;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.subbroker.ISubBrokerManager;
import org.apache.bifromq.sysprops.props.DistMatchParallelism;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistWorkerCoProcFactory
implements IKVRangeCoProcFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DistWorkerCoProcFactory.class);
    private final IEventCollector eventCollector;
    private final IResourceThrottler resourceThrottler;
    private final IMessageDeliverer deliverer;
    private final ISettingProvider settingProvider;
    private final ISubscriptionCleaner subscriptionChecker;
    private final ExecutorService matchExecutor;
    private final int fanoutParallelism;
    private final int inlineFanOutThreshold;

    public DistWorkerCoProcFactory(IDistClient distClient, IEventCollector eventCollector, IResourceThrottler resourceThrottler, ISubBrokerManager subBrokerManager, IMessageDeliverer messageDeliverer, ISettingProvider settingProvider, int fanoutParallelism, int inlineFanOutThreshold) {
        this.eventCollector = eventCollector;
        this.resourceThrottler = resourceThrottler;
        this.deliverer = messageDeliverer;
        this.settingProvider = settingProvider;
        this.fanoutParallelism = fanoutParallelism;
        this.inlineFanOutThreshold = inlineFanOutThreshold;
        this.subscriptionChecker = new SubscriptionCleaner(subBrokerManager, distClient);
        this.matchExecutor = ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)new ForkJoinPool((Integer)DistMatchParallelism.INSTANCE.get(), new ForkJoinPool.ForkJoinWorkerThreadFactory(){
            final AtomicInteger index = new AtomicInteger(0);

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                worker.setName(String.format("topic-matcher-%d", this.index.incrementAndGet()));
                worker.setDaemon(false);
                return worker;
            }
        }, null, false), (String)"topic-matcher", (Tag[])new Tag[0]);
    }

    public IKVRangeCoProc createCoProc(String clusterId, String storeId, KVRangeId id, Supplier<IKVRangeRefreshableReader> rangeReaderProvider) {
        SubscriptionCache routeCache = new SubscriptionCache(id, rangeReaderProvider, this.settingProvider, this.eventCollector, this.matchExecutor);
        TenantsStats tenantsState = new TenantsStats(rangeReaderProvider, "clusterId", clusterId, "storeId", storeId, "rangeId", KVRangeIdUtil.toString((KVRangeId)id));
        DeliverExecutorGroup deliverExecutorGroup = new DeliverExecutorGroup(this.deliverer, this.eventCollector, this.resourceThrottler, this.settingProvider, this.fanoutParallelism, this.inlineFanOutThreshold);
        return new DistWorkerCoProc(id, rangeReaderProvider, routeCache, tenantsState, deliverExecutorGroup, this.subscriptionChecker);
    }

    public void close() {
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.matchExecutor, (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }
}

