/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.server;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.basekv.raft.exception.DropProposalException;
import org.apache.bifromq.basekv.store.IKVRangeStore;
import org.apache.bifromq.basekv.store.exception.KVRangeException;
import org.apache.bifromq.basekv.store.exception.KVRangeStoreException;
import org.apache.bifromq.basekv.store.proto.KVRangeRWReply;
import org.apache.bifromq.basekv.store.proto.KVRangeRWRequest;
import org.apache.bifromq.basekv.store.proto.ReplyCode;
import org.apache.bifromq.baserpc.server.ResponsePipeline;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class MutatePipeline
extends ResponsePipeline<KVRangeRWRequest, KVRangeRWReply> {
    private final Logger log;
    private final IKVRangeStore kvRangeStore;

    MutatePipeline(IKVRangeStore kvRangeStore, StreamObserver<KVRangeRWReply> responseObserver) {
        super(responseObserver);
        this.kvRangeStore = kvRangeStore;
        this.log = MDCLogger.getLogger(MutatePipeline.class, (String[])new String[]{"clusterId", kvRangeStore.clusterId(), "storeId", kvRangeStore.id()});
    }

    protected CompletableFuture<KVRangeRWReply> handleRequest(String s, KVRangeRWRequest request) {
        this.log.trace("Handling rw range request:req={}", (Object)request);
        return switch (request.getRequestTypeCase()) {
            case KVRangeRWRequest.RequestTypeCase.DELETE -> this.mutate(request, this::delete).toCompletableFuture();
            case KVRangeRWRequest.RequestTypeCase.PUT -> this.mutate(request, this::put).toCompletableFuture();
            default -> this.mutate(request, this::mutateCoProc).toCompletableFuture();
        };
    }

    private CompletionStage<KVRangeRWReply> delete(KVRangeRWRequest request) {
        return this.kvRangeStore.delete(request.getVer(), request.getKvRangeId(), request.getDelete()).thenApply(v -> KVRangeRWReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.Ok).setDeleteResult(v).build());
    }

    private CompletionStage<KVRangeRWReply> put(KVRangeRWRequest request) {
        return this.kvRangeStore.put(request.getVer(), request.getKvRangeId(), request.getPut().getKey(), request.getPut().getValue()).thenApply(v -> KVRangeRWReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.Ok).setPutResult(v).build());
    }

    private CompletionStage<KVRangeRWReply> mutateCoProc(KVRangeRWRequest request) {
        return this.kvRangeStore.mutateCoProc(request.getVer(), request.getKvRangeId(), request.getRwCoProc()).thenApply(v -> KVRangeRWReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.Ok).setRwCoProcResult(v).build());
    }

    private CompletionStage<KVRangeRWReply> mutate(KVRangeRWRequest request, Function<KVRangeRWRequest, CompletionStage<KVRangeRWReply>> mutateFn) {
        return mutateFn.apply(request).exceptionally(CompletableFutureUtil.unwrap(e -> {
            if (e instanceof KVRangeException.BadVersion) {
                KVRangeException.BadVersion badVersion = (KVRangeException.BadVersion)e;
                KVRangeRWReply.Builder replyBuilder = KVRangeRWReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.BadVersion);
                if (badVersion.latest != null) {
                    replyBuilder.setLatest(badVersion.latest);
                }
                return replyBuilder.build();
            }
            if (e instanceof KVRangeException.TryLater) {
                KVRangeException.TryLater tryLater = (KVRangeException.TryLater)e;
                KVRangeRWReply.Builder replyBuilder = KVRangeRWReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.TryLater);
                if (tryLater.latest != null) {
                    replyBuilder.setLatest(tryLater.latest);
                }
                return replyBuilder.build();
            }
            if (e instanceof KVRangeStoreException.KVRangeNotFoundException) {
                return KVRangeRWReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.TryLater).build();
            }
            if (e instanceof KVRangeException.BadRequest) {
                KVRangeException.BadRequest badRequest = (KVRangeException.BadRequest)e;
                KVRangeRWReply.Builder replyBuilder = KVRangeRWReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.BadRequest);
                if (badRequest.latest != null) {
                    replyBuilder.setLatest(badRequest.latest);
                }
                return replyBuilder.build();
            }
            if (e instanceof DropProposalException.TransferringLeaderException) {
                return KVRangeRWReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.TryLater).build();
            }
            if (e instanceof DropProposalException.NoLeaderException) {
                return KVRangeRWReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.TryLater).build();
            }
            if (e instanceof DropProposalException.ForwardTimeoutException) {
                return KVRangeRWReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.TryLater).build();
            }
            if (e instanceof DropProposalException.OverriddenException) {
                return KVRangeRWReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.TryLater).build();
            }
            if (e instanceof DropProposalException.SupersededBySnapshotException) {
                return KVRangeRWReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.TryLater).build();
            }
            this.log.debug("Handle rw request error: reqId={}", (Object)request.getReqId(), e);
            return KVRangeRWReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.InternalError).build();
        }));
    }
}

