/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Cleaner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.bifromq.basekv.localengine.IKVSpaceReader;
import org.apache.bifromq.basekv.localengine.KVEngineException;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.basekv.localengine.rocksdb.IRocksDBKVSpaceCheckpoint;
import org.apache.bifromq.basekv.localengine.rocksdb.IRocksDBKVSpaceEpoch;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBHelper;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBKVSpaceCheckpointReader;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.TableFormatConfig;
import org.slf4j.Logger;

class RocksDBKVSpaceCheckpoint
implements IRocksDBKVSpaceCheckpoint {
    private static final Cleaner CLEANER = Cleaner.create();
    private final String id;
    private final KVSpaceOpMeters opMeters;
    private final Logger logger;
    private final String cpId;
    private final DBOptions dbOptions;
    private final ColumnFamilyDescriptor cfDesc;
    private final Cleaner.Cleanable cleanable;
    private final IRocksDBKVSpaceEpoch handle;
    private final Map<ByteString, ByteString> metadata;

    RocksDBKVSpaceCheckpoint(String id, String cpId, File cpDir, Predicate<String> isLatest, KVSpaceOpMeters opMeters, Logger logger) {
        this.id = id;
        this.opMeters = opMeters;
        this.logger = logger;
        this.cpId = cpId;
        try {
            this.cfDesc = new ColumnFamilyDescriptor("default".getBytes());
            this.cfDesc.getOptions().setTableFormatConfig((TableFormatConfig)new BlockBasedTableConfig().setNoBlockCache(true).setBlockCache(null));
            this.dbOptions = new DBOptions();
            List<ColumnFamilyDescriptor> cfDescs = List.of(this.cfDesc);
            ArrayList handles = new ArrayList();
            final RocksDB roDB = RocksDB.openReadOnly((DBOptions)this.dbOptions, (String)cpDir.getAbsolutePath(), cfDescs, handles);
            final ColumnFamilyHandle cfHandle = (ColumnFamilyHandle)handles.get(0);
            this.handle = new IRocksDBKVSpaceEpoch(){

                @Override
                public RocksDB db() {
                    return roDB;
                }

                @Override
                public ColumnFamilyHandle cf() {
                    return cfHandle;
                }
            };
            this.cleanable = CLEANER.register(this, new ClosableResources(id, cpId, cpDir, this.cfDesc, cfHandle, roDB, this.dbOptions, isLatest, this.logger));
            this.metadata = RocksDBHelper.getMetadata(this.handle);
        }
        catch (RocksDBException e) {
            throw new KVEngineException("Failed to open checkpoint", (Throwable)e);
        }
        this.logger.debug("Checkpoint[{}] of kvspace[{}] created", (Object)cpId, (Object)id);
    }

    public String cpId() {
        return this.cpId;
    }

    public IKVSpaceReader newReader() {
        return new RocksDBKVSpaceCheckpointReader(this.id, this.opMeters, this.logger, this, this.handle, this.metadata);
    }

    @Override
    public void close() {
        this.cleanable.clean();
    }

    private record ClosableResources(String id, String cpId, File cpDir, ColumnFamilyDescriptor cfDesc, ColumnFamilyHandle cfHandle, RocksDB roDB, DBOptions dbOptions, Predicate<String> isLatest, Logger log) implements Runnable
    {
        @Override
        public void run() {
            this.log.debug("Clean up checkpoint[{}] of kvspace[{}]", (Object)this.cpId, (Object)this.id);
            this.roDB.destroyColumnFamilyHandle(this.cfHandle);
            this.cfDesc.getOptions().close();
            this.roDB.close();
            this.dbOptions.close();
            if (!this.isLatest.test(this.cpId)) {
                this.log.debug("delete checkpoint[{}] of kvspace[{}] in path: {}", new Object[]{this.cpId, this.id, this.cpDir.getAbsolutePath()});
                try {
                    RocksDBHelper.deleteDir(this.cpDir.toPath());
                }
                catch (IOException e) {
                    this.log.error("Failed to clean checkpoint at path:{}", (Object)this.cpDir);
                }
            }
        }
    }
}

