/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.sysprops;

import lombok.Generated;
import org.apache.bifromq.sysprops.parser.PropParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BifroMQSysProp<T, P extends PropParser<T>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BifroMQSysProp.class);
    private final String propKey;
    private final P parser;
    private final T defaultValue;
    private T currentValue;

    protected BifroMQSysProp(String propKey, T defaultValue, P parser) {
        this.propKey = propKey;
        this.defaultValue = defaultValue;
        this.parser = parser;
        this.resolve();
    }

    private String sysPropValue(String key) {
        String value = null;
        try {
            value = System.getProperty(key);
        }
        catch (SecurityException e) {
            log.warn("Failed to retrieve a system property '{}'", (Object)key, (Object)e);
        }
        return value;
    }

    public final synchronized void resolve() {
        String value = this.sysPropValue(this.propKey);
        if (value == null) {
            this.currentValue = this.defaultValue;
            return;
        }
        if ((value = value.trim().toLowerCase()).isEmpty()) {
            this.currentValue = this.defaultValue;
            return;
        }
        try {
            this.currentValue = this.parser.parse(value);
        }
        catch (Throwable e) {
            log.warn("Failed to parse system prop '{}':{} - using the default value: {}", new Object[]{this.propKey, value, this.defaultValue});
            this.currentValue = this.defaultValue;
        }
    }

    public final String propKey() {
        return this.propKey;
    }

    public final T get() {
        return this.currentValue;
    }
}

