/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import com.google.common.base.Strings;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.apiserver.Headers;
import org.apache.bifromq.apiserver.http.IHTTPRequestHandler;
import org.apache.bifromq.apiserver.http.handler.utils.HeaderUtils;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.Setting;

abstract class TenantAwareHandler
implements IHTTPRequestHandler {
    private final ISettingProvider settingProvider;

    protected TenantAwareHandler(ISettingProvider settingProvider) {
        this.settingProvider = settingProvider;
    }

    @Override
    public final CompletableFuture<FullHttpResponse> handle(long reqId, FullHttpRequest req) {
        String tenantId = HeaderUtils.getHeader(Headers.HEADER_TENANT_ID, (HttpRequest)req, false);
        if (Strings.isNullOrEmpty((String)tenantId)) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.BAD_REQUEST, Unpooled.EMPTY_BUFFER);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
            response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
            return CompletableFuture.completedFuture(response);
        }
        Integer maxUserPayloadBytes = (Integer)this.settingProvider.provide(Setting.MaxUserPayloadBytes, tenantId);
        if (HttpUtil.getContentLength((HttpMessage)req, (int)-1) > maxUserPayloadBytes) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
            return CompletableFuture.completedFuture(response);
        }
        req.retain();
        return this.handle(reqId, tenantId, req);
    }

    protected abstract CompletableFuture<FullHttpResponse> handle(long var1, String var3, FullHttpRequest var4);
}

