/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;

public class UTF8Util {
    private static final int MAX_STRING_LENGTH = 65535;

    public static boolean isWellFormed(String str, boolean sanityCheck) {
        int len = str.length();
        if (len == 0) {
            return true;
        }
        if (len > 65535) {
            return false;
        }
        char cl = str.charAt(0);
        if (cl == '\u0000') {
            return false;
        }
        if (sanityCheck && UTF8Util.isUnacceptableChar(cl)) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            char cr = str.charAt(i);
            if (cr == '\u0000') {
                return false;
            }
            if (Character.isSurrogatePair(cl, cr)) {
                return false;
            }
            if (sanityCheck && UTF8Util.isUnacceptableChar(cr)) {
                return false;
            }
            cl = cr;
        }
        return true;
    }

    public static boolean isValidUTF8Payload(ByteBuffer payload) {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        try {
            CharBuffer charBuffer = decoder.decode(payload);
            for (int i = 0; i < charBuffer.length(); ++i) {
                char ch = charBuffer.get(i);
                if (!UTF8Util.isUnacceptableChar(ch)) continue;
                return false;
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public static boolean isValidUTF8Payload(byte[] payload) {
        return UTF8Util.isValidUTF8Payload(ByteBuffer.wrap(payload));
    }

    private static boolean isUnacceptableChar(char ch) {
        return Character.isISOControl(ch) || !Character.isDefined(ch);
    }
}

