/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.client.scheduler;

import com.google.protobuf.ByteString;
import java.util.Optional;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.client.KVRangeRouterUtil;
import org.apache.bifromq.basekv.client.KVRangeSetting;
import org.apache.bifromq.basekv.client.scheduler.BatchQueryCall;
import org.apache.bifromq.basekv.client.scheduler.BatchQueryCallBuilderFactory;
import org.apache.bifromq.basekv.client.scheduler.IBatchQueryCallBuilder;
import org.apache.bifromq.basekv.client.scheduler.QueryCallBatcherKey;
import org.apache.bifromq.basescheduler.BatchCallScheduler;

public abstract class QueryCallScheduler<ReqT, RespT, BatchCallT extends BatchQueryCall<ReqT, RespT>>
extends BatchCallScheduler<ReqT, RespT, QueryCallBatcherKey> {
    protected final IBaseKVStoreClient storeClient;

    public QueryCallScheduler(IBatchQueryCallBuilder<ReqT, RespT, BatchCallT> batchCallBuilder, long maxBurstLatency, IBaseKVStoreClient storeClient) {
        super(new BatchQueryCallBuilderFactory<ReqT, RespT, BatchCallT>(storeClient, batchCallBuilder), maxBurstLatency);
        this.storeClient = storeClient;
    }

    protected String selectStore(KVRangeSetting setting, ReqT request) {
        return setting.leader();
    }

    protected abstract int selectQueue(ReqT var1);

    protected abstract boolean isLinearizable(ReqT var1);

    protected abstract ByteString rangeKey(ReqT var1);

    protected final Optional<QueryCallBatcherKey> find(ReqT req) {
        return KVRangeRouterUtil.findByKey(this.rangeKey(req), this.storeClient.latestEffectiveRouter()).map(range -> new QueryCallBatcherKey(range.id(), this.selectStore((KVRangeSetting)range, req), this.selectQueue(req), range.ver(), this.isLinearizable(req)));
    }
}

