/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.service;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.dist.client.MatchResult;
import org.apache.bifromq.dist.client.UnmatchResult;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;
import org.apache.bifromq.mqtt.inbox.util.DelivererKeyUtil;
import org.apache.bifromq.mqtt.service.ILocalDistService;
import org.apache.bifromq.mqtt.service.ILocalSessionRegistry;
import org.apache.bifromq.mqtt.service.ILocalTopicRouter;
import org.apache.bifromq.mqtt.session.IMQTTSession;
import org.apache.bifromq.mqtt.session.IMQTTTransientSession;
import org.apache.bifromq.plugin.resourcethrottler.IResourceThrottler;
import org.apache.bifromq.plugin.resourcethrottler.TenantResourceType;
import org.apache.bifromq.plugin.subbroker.CheckReply;
import org.apache.bifromq.plugin.subbroker.DeliveryPack;
import org.apache.bifromq.plugin.subbroker.DeliveryPackage;
import org.apache.bifromq.plugin.subbroker.DeliveryReply;
import org.apache.bifromq.plugin.subbroker.DeliveryRequest;
import org.apache.bifromq.plugin.subbroker.DeliveryResult;
import org.apache.bifromq.plugin.subbroker.DeliveryResults;
import org.apache.bifromq.type.MatchInfo;
import org.apache.bifromq.type.TopicMessagePack;
import org.apache.bifromq.util.SizeUtil;
import org.apache.bifromq.util.TopicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDistService
implements ILocalDistService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalDistService.class);
    private final String serverId;
    private final IDistClient distClient;
    private final ILocalTopicRouter localTopicRouter;
    private final IResourceThrottler resourceThrottler;
    private final ILocalSessionRegistry sessionRegistry;

    public LocalDistService(String serverId, ILocalSessionRegistry sessionRegistry, ILocalTopicRouter localTopicRouter, IDistClient distClient, IResourceThrottler resourceThrottler) {
        this.serverId = serverId;
        this.sessionRegistry = sessionRegistry;
        this.localTopicRouter = localTopicRouter;
        this.distClient = distClient;
        this.resourceThrottler = resourceThrottler;
    }

    @Override
    public CompletableFuture<MatchResult> match(long reqId, String topicFilter, long incarnation, IMQTTTransientSession session) {
        String tenantId = session.clientInfo().getTenantId();
        if (TopicUtil.isSharedSubscription((String)topicFilter)) {
            return this.distClient.addRoute(reqId, tenantId, TopicUtil.from((String)topicFilter), ILocalDistService.globalize(session.channelId()), DelivererKeyUtil.toDelivererKey((String)tenantId, (String)ILocalDistService.globalize(session.channelId()), (String)this.serverId), 0, incarnation);
        }
        return this.localTopicRouter.addTopicRoute(reqId, tenantId, topicFilter, incarnation, session.channelId());
    }

    @Override
    public CompletableFuture<UnmatchResult> unmatch(long reqId, String topicFilter, long incarnation, IMQTTTransientSession session) {
        String tenantId = session.clientInfo().getTenantId();
        if (TopicUtil.isSharedSubscription((String)topicFilter)) {
            return this.distClient.removeRoute(reqId, tenantId, TopicUtil.from((String)topicFilter), ILocalDistService.globalize(session.channelId()), DelivererKeyUtil.toDelivererKey((String)tenantId, (String)ILocalDistService.globalize(session.channelId()), (String)this.serverId), 0, incarnation);
        }
        return this.localTopicRouter.removeTopicRoute(reqId, tenantId, topicFilter, incarnation, session.channelId());
    }

    @Override
    public CompletableFuture<DeliveryReply> dist(DeliveryRequest request) {
        DeliveryReply.Builder replyBuilder = DeliveryReply.newBuilder().setCode(DeliveryReply.Code.OK);
        for (Map.Entry packageEntry : request.getPackageMap().entrySet()) {
            String tenantId = (String)packageEntry.getKey();
            DeliveryResults.Builder resultsBuilder = DeliveryResults.newBuilder();
            ITenantMeter tenantMeter = ITenantMeter.get((String)tenantId);
            boolean isFanOutThrottled = !this.resourceThrottler.hasResource(tenantId, TenantResourceType.TotalTransientFanOutBytesPerSeconds);
            HashSet<MatchInfo> ok = new HashSet<MatchInfo>();
            HashSet<MatchInfo> skip = new HashSet<MatchInfo>();
            HashSet<MatchInfo> noSub = new HashSet<MatchInfo>();
            long totalFanOutBytes = 0L;
            for (DeliveryPack writePack : ((DeliveryPackage)packageEntry.getValue()).getPackList()) {
                TopicMessagePack topicMsgPack = writePack.getMessagePack();
                HashMap<IMQTTTransientSession, Map> matchedSessions = new HashMap<IMQTTTransientSession, Map>();
                for (MatchInfo matchInfo2 : writePack.getMatchInfoList()) {
                    if (ILocalDistService.isGlobal(matchInfo2.getReceiverId())) {
                        IMQTTSession session = this.sessionRegistry.get(ILocalDistService.parseReceiverId(matchInfo2.getReceiverId()));
                        if (session instanceof IMQTTTransientSession) {
                            if (isFanOutThrottled && !matchedSessions.isEmpty()) {
                                skip.add(matchInfo2);
                                continue;
                            }
                            matchedSessions.computeIfAbsent((IMQTTTransientSession)session, k -> new HashMap()).put(new IMQTTTransientSession.MatchedTopicFilter(matchInfo2.getMatcher().getMqttTopicFilter(), matchInfo2.getIncarnation()), matchInfo2);
                            continue;
                        }
                        noSub.add(matchInfo2);
                        continue;
                    }
                    Optional<CompletableFuture<? extends ILocalTopicRouter.ILocalRoutes>> routesFutureOpt = this.localTopicRouter.getTopicRoutes(tenantId, matchInfo2);
                    if (routesFutureOpt.isEmpty()) {
                        noSub.add(matchInfo2);
                        continue;
                    }
                    CompletableFuture<? extends ILocalTopicRouter.ILocalRoutes> routesFuture = routesFutureOpt.get();
                    if (!routesFuture.isDone() || routesFuture.isCompletedExceptionally()) {
                        skip.add(matchInfo2);
                        continue;
                    }
                    ILocalTopicRouter.ILocalRoutes localRoutes = routesFuture.join();
                    if (!localRoutes.localReceiverId().equals(matchInfo2.getReceiverId())) {
                        noSub.add(matchInfo2);
                        continue;
                    }
                    for (Map.Entry<String, Long> route : localRoutes.routesInfo().entrySet()) {
                        String sessionId = route.getKey();
                        long incarnation = route.getValue();
                        IMQTTSession session = this.sessionRegistry.get(sessionId);
                        if (!(session instanceof IMQTTTransientSession)) continue;
                        if (isFanOutThrottled && !matchedSessions.isEmpty()) {
                            skip.add(matchInfo2);
                            continue;
                        }
                        matchedSessions.computeIfAbsent((IMQTTTransientSession)session, k -> new HashMap()).put(new IMQTTTransientSession.MatchedTopicFilter(matchInfo2.getMatcher().getMqttTopicFilter(), incarnation), matchInfo2);
                    }
                }
                long msgPackSize = SizeUtil.estSizeOf((TopicMessagePack)topicMsgPack);
                int fanoutScale = 0;
                for (Map.Entry entry : matchedSessions.entrySet()) {
                    IMQTTTransientSession session = (IMQTTTransientSession)entry.getKey();
                    Map matchedTopics = (Map)entry.getValue();
                    Set<IMQTTTransientSession.MatchedTopicFilter> obsoleted = session.publish(topicMsgPack, matchedTopics.keySet());
                    for (IMQTTTransientSession.MatchedTopicFilter matchedTopic : matchedTopics.keySet()) {
                        MatchInfo matchInfo3 = (MatchInfo)matchedTopics.get(matchedTopic);
                        if (obsoleted.contains(matchedTopic)) {
                            noSub.add(matchInfo3);
                            continue;
                        }
                        ok.add(matchInfo3);
                        ++fanoutScale;
                    }
                }
                totalFanOutBytes += msgPackSize * (long)fanoutScale;
            }
            tenantMeter.recordSummary(TenantMetric.MqttTransientFanOutBytes, (double)totalFanOutBytes);
            Sets.difference((Set)Sets.union(ok, skip), noSub).forEach(matchInfo -> resultsBuilder.addResult(DeliveryResult.newBuilder().setMatchInfo(matchInfo).setCode(DeliveryResult.Code.OK).build()));
            noSub.forEach(matchInfo -> resultsBuilder.addResult(DeliveryResult.newBuilder().setMatchInfo(matchInfo).setCode(DeliveryResult.Code.NO_SUB).build()));
            replyBuilder.putResult(tenantId, resultsBuilder.build());
        }
        return CompletableFuture.completedFuture(replyBuilder.build());
    }

    @Override
    public CheckReply.Code checkMatchInfo(String tenantId, MatchInfo matchInfo) {
        if (ILocalDistService.isGlobal(matchInfo.getReceiverId())) {
            IMQTTSession session = this.sessionRegistry.get(ILocalDistService.parseReceiverId(matchInfo.getReceiverId()));
            if (session == null) {
                return CheckReply.Code.NO_RECEIVER;
            }
            if (session instanceof IMQTTTransientSession) {
                IMQTTTransientSession transientSession = (IMQTTTransientSession)session;
                return transientSession.hasSubscribed(matchInfo.getMatcher().getMqttTopicFilter()) ? CheckReply.Code.OK : CheckReply.Code.NO_SUB;
            }
            return CheckReply.Code.ERROR;
        }
        Optional<CompletableFuture<? extends ILocalTopicRouter.ILocalRoutes>> routesFutureOpt = this.localTopicRouter.getTopicRoutes(tenantId, matchInfo);
        if (routesFutureOpt.isEmpty()) {
            return CheckReply.Code.NO_RECEIVER;
        }
        CompletableFuture<? extends ILocalTopicRouter.ILocalRoutes> routesFuture = routesFutureOpt.get();
        if (!routesFuture.isDone() || routesFuture.isCompletedExceptionally()) {
            return CheckReply.Code.OK;
        }
        ILocalTopicRouter.ILocalRoutes localRoutes = routesFuture.join();
        if (!localRoutes.localReceiverId().equals(matchInfo.getReceiverId())) {
            return CheckReply.Code.NO_RECEIVER;
        }
        if (localRoutes.routesInfo().isEmpty()) {
            return CheckReply.Code.NO_RECEIVER;
        }
        return CheckReply.Code.OK;
    }
}

