/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class UserProvider
extends KeyProvider {
    public static final String SCHEME_NAME = "user";
    private final UserGroupInformation user;
    private final Credentials credentials;
    private final Map<String, KeyProvider.Metadata> cache = new HashMap<String, KeyProvider.Metadata>();

    private UserProvider(Configuration conf) throws IOException {
        super(conf);
        this.user = UserGroupInformation.getCurrentUser();
        this.credentials = this.user.getCredentials();
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    @Override
    public synchronized KeyProvider.KeyVersion getKeyVersion(String versionName) throws IOException {
        byte[] bytes = this.credentials.getSecretKey(new Text(versionName));
        if (bytes == null) {
            return null;
        }
        return new KeyProvider.KeyVersion(UserProvider.getBaseName(versionName), versionName, bytes);
    }

    @Override
    public synchronized KeyProvider.Metadata getMetadata(String name) throws IOException {
        if (this.cache.containsKey(name)) {
            return this.cache.get(name);
        }
        byte[] serialized = this.credentials.getSecretKey(new Text(name));
        if (serialized == null) {
            return null;
        }
        KeyProvider.Metadata result = new KeyProvider.Metadata(serialized);
        this.cache.put(name, result);
        return result;
    }

    @Override
    public synchronized KeyProvider.KeyVersion createKey(String name, byte[] material, KeyProvider.Options options) throws IOException {
        Text nameT = new Text(name);
        if (this.credentials.getSecretKey(nameT) != null) {
            throw new IOException("Key " + name + " already exists in " + this);
        }
        if (options.getBitLength() != 8 * material.length) {
            throw new IOException("Wrong key length. Required " + options.getBitLength() + ", but got " + 8 * material.length);
        }
        KeyProvider.Metadata meta = new KeyProvider.Metadata(options.getCipher(), options.getBitLength(), options.getDescription(), options.getAttributes(), new Date(), 1);
        this.cache.put(name, meta);
        String versionName = UserProvider.buildVersionName(name, 0);
        this.credentials.addSecretKey(nameT, meta.serialize());
        this.credentials.addSecretKey(new Text(versionName), material);
        return new KeyProvider.KeyVersion(name, versionName, material);
    }

    @Override
    public synchronized void deleteKey(String name) throws IOException {
        KeyProvider.Metadata meta = this.getMetadata(name);
        if (meta == null) {
            throw new IOException("Key " + name + " does not exist in " + this);
        }
        for (int v = 0; v < meta.getVersions(); ++v) {
            this.credentials.removeSecretKey(new Text(UserProvider.buildVersionName(name, v)));
        }
        this.credentials.removeSecretKey(new Text(name));
        this.cache.remove(name);
    }

    @Override
    public synchronized KeyProvider.KeyVersion rollNewVersion(String name, byte[] material) throws IOException {
        KeyProvider.Metadata meta = this.getMetadata(name);
        if (meta == null) {
            throw new IOException("Key " + name + " not found");
        }
        if (meta.getBitLength() != 8 * material.length) {
            throw new IOException("Wrong key length. Required " + meta.getBitLength() + ", but got " + 8 * material.length);
        }
        int nextVersion = meta.addVersion();
        this.credentials.addSecretKey(new Text(name), meta.serialize());
        String versionName = UserProvider.buildVersionName(name, nextVersion);
        this.credentials.addSecretKey(new Text(versionName), material);
        return new KeyProvider.KeyVersion(name, versionName, material);
    }

    public String toString() {
        return "user:///";
    }

    @Override
    public synchronized void flush() {
        this.user.addCredentials(this.credentials);
    }

    @Override
    public synchronized List<String> getKeys() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        List<Text> keys2 = this.credentials.getAllSecretKeys();
        for (Text key : keys2) {
            if (key.find("@") != -1) continue;
            list.add(key.toString());
        }
        return list;
    }

    @Override
    public synchronized List<KeyProvider.KeyVersion> getKeyVersions(String name) throws IOException {
        ArrayList<KeyProvider.KeyVersion> list = new ArrayList<KeyProvider.KeyVersion>();
        KeyProvider.Metadata km3 = this.getMetadata(name);
        if (km3 != null) {
            int latestVersion = km3.getVersions();
            for (int i = 0; i < latestVersion; ++i) {
                KeyProvider.KeyVersion v = this.getKeyVersion(UserProvider.buildVersionName(name, i));
                if (v == null) continue;
                list.add(v);
            }
        }
        return list;
    }

    public static class Factory
    extends KeyProviderFactory {
        @Override
        public KeyProvider createProvider(URI providerName, Configuration conf) throws IOException {
            if (UserProvider.SCHEME_NAME.equals(providerName.getScheme())) {
                return new UserProvider(conf);
            }
            return null;
        }
    }
}

