/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.fs.oss.token;

import com.aliyun.oss.common.auth.DefaultCredentials;
import com.aliyun.oss.common.auth.InvalidCredentialsException;
import java.util.Map;
import org.apache.fluss.fs.oss.token.DynamicTemporaryOssCredentialsProvider;
import org.apache.fluss.fs.token.Credentials;
import org.apache.fluss.fs.token.CredentialsJsonSerde;
import org.apache.fluss.fs.token.ObtainedSecurityToken;
import org.apache.fluss.fs.token.SecurityTokenReceiver;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSSecurityTokenReceiver
implements SecurityTokenReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(OSSSecurityTokenReceiver.class);
    static volatile com.aliyun.oss.common.auth.Credentials credentials;
    static volatile Map<String, String> additionInfos;

    public static void updateHadoopConfig(Configuration hadoopConfig) {
        OSSSecurityTokenReceiver.updateHadoopConfig(hadoopConfig, DynamicTemporaryOssCredentialsProvider.NAME);
    }

    protected static void updateHadoopConfig(Configuration hadoopConfig, String credentialsProviderName) {
        LOG.info("Updating Hadoop configuration");
        Object providers = hadoopConfig.get("fs.oss.credentials.provider", "");
        if (!((String)providers).contains(credentialsProviderName)) {
            if (((String)providers).isEmpty()) {
                LOG.debug("Setting provider");
                providers = credentialsProviderName;
            } else {
                providers = credentialsProviderName + "," + (String)providers;
                LOG.debug("Prepending provider, new providers value: {}", providers);
            }
            hadoopConfig.set("fs.oss.credentials.provider", (String)providers);
        } else {
            LOG.debug("Provider already exists");
        }
        if (additionInfos == null) {
            throw new InvalidCredentialsException("Credentials is not ready.");
        }
        for (Map.Entry<String, String> entry : additionInfos.entrySet()) {
            hadoopConfig.set(entry.getKey(), entry.getValue());
        }
        LOG.info("Updated Hadoop configuration successfully");
    }

    public String scheme() {
        return "oss";
    }

    public void onNewTokensObtained(ObtainedSecurityToken token) {
        LOG.info("Updating session credentials");
        byte[] tokenBytes = token.getToken();
        Credentials flussCredentials = CredentialsJsonSerde.fromJson((byte[])tokenBytes);
        credentials = new DefaultCredentials(flussCredentials.getAccessKeyId(), flussCredentials.getSecretAccessKey(), flussCredentials.getSecurityToken());
        additionInfos = token.getAdditionInfos();
        LOG.info("Session credentials updated successfully with access key: {}.", (Object)credentials.getAccessKeyId());
    }

    public static com.aliyun.oss.common.auth.Credentials getCredentials() {
        return credentials;
    }
}

