/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.utils;

import java.math.BigDecimal;
import org.apache.fluss.lake.paimon.PaimonLakeCatalog;
import org.apache.fluss.row.BinaryString;
import org.apache.fluss.row.Decimal;
import org.apache.fluss.row.TimestampLtz;
import org.apache.fluss.row.TimestampNtz;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;

public class PaimonRowAsFlussRow
implements org.apache.fluss.row.InternalRow {
    private InternalRow paimonRow;

    public PaimonRowAsFlussRow() {
    }

    public PaimonRowAsFlussRow(InternalRow paimonRow) {
        this.paimonRow = paimonRow;
    }

    public PaimonRowAsFlussRow replaceRow(InternalRow paimonRow) {
        this.paimonRow = paimonRow;
        return this;
    }

    public int getFieldCount() {
        return this.paimonRow.getFieldCount() - PaimonLakeCatalog.SYSTEM_COLUMNS.size();
    }

    public boolean isNullAt(int pos) {
        return this.paimonRow.isNullAt(pos);
    }

    public boolean getBoolean(int pos) {
        return this.paimonRow.getBoolean(pos);
    }

    public byte getByte(int pos) {
        return this.paimonRow.getByte(pos);
    }

    public short getShort(int pos) {
        return this.paimonRow.getShort(pos);
    }

    public int getInt(int pos) {
        return this.paimonRow.getInt(pos);
    }

    public long getLong(int pos) {
        return this.paimonRow.getLong(pos);
    }

    public float getFloat(int pos) {
        return this.paimonRow.getFloat(pos);
    }

    public double getDouble(int pos) {
        return this.paimonRow.getDouble(pos);
    }

    public BinaryString getChar(int pos, int length) {
        return BinaryString.fromBytes((byte[])this.paimonRow.getString(pos).toBytes());
    }

    public BinaryString getString(int pos) {
        return BinaryString.fromBytes((byte[])this.paimonRow.getString(pos).toBytes());
    }

    public Decimal getDecimal(int pos, int precision, int scale) {
        org.apache.paimon.data.Decimal paimonDecimal = this.paimonRow.getDecimal(pos, precision, scale);
        if (paimonDecimal.isCompact()) {
            return Decimal.fromUnscaledLong((long)paimonDecimal.toUnscaledLong(), (int)precision, (int)scale);
        }
        return Decimal.fromBigDecimal((BigDecimal)paimonDecimal.toBigDecimal(), (int)precision, (int)scale);
    }

    public TimestampNtz getTimestampNtz(int pos, int precision) {
        Timestamp timestamp = this.paimonRow.getTimestamp(pos, precision);
        if (TimestampNtz.isCompact((int)precision)) {
            return TimestampNtz.fromMillis((long)timestamp.getMillisecond());
        }
        return TimestampNtz.fromMillis((long)timestamp.getMillisecond(), (int)timestamp.getNanoOfMillisecond());
    }

    public TimestampLtz getTimestampLtz(int pos, int precision) {
        Timestamp timestamp = this.paimonRow.getTimestamp(pos, precision);
        if (TimestampLtz.isCompact((int)precision)) {
            return TimestampLtz.fromEpochMillis((long)timestamp.getMillisecond());
        }
        return TimestampLtz.fromEpochMillis((long)timestamp.getMillisecond(), (int)timestamp.getNanoOfMillisecond());
    }

    public byte[] getBinary(int pos, int length) {
        return this.paimonRow.getBinary(pos);
    }

    public byte[] getBytes(int pos) {
        return this.paimonRow.getBinary(pos);
    }
}

