/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.append;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.utils.Pair;

public class AppendPreCommitCompactCoordinator {
    private final long targetFileSize;
    private final Map<BinaryRow, PartitionFiles> partitions;

    public AppendPreCommitCompactCoordinator(long targetFileSize) {
        this.targetFileSize = targetFileSize;
        this.partitions = new LinkedHashMap<BinaryRow, PartitionFiles>();
    }

    public Optional<Pair<BinaryRow, List<DataFileMeta>>> addFile(BinaryRow partition, DataFileMeta file) {
        PartitionFiles files = this.partitions.computeIfAbsent(partition, ignore -> new PartitionFiles());
        files.addFile(file);
        if (files.totalSize >= this.targetFileSize) {
            this.partitions.remove(partition);
            return Optional.of(Pair.of(partition, files.files));
        }
        return Optional.empty();
    }

    public List<Pair<BinaryRow, List<DataFileMeta>>> emitAll() {
        List<Pair<BinaryRow, List<DataFileMeta>>> result = this.partitions.entrySet().stream().map(e -> Pair.of(e.getKey(), ((PartitionFiles)e.getValue()).files)).collect(Collectors.toList());
        this.partitions.clear();
        return result;
    }

    private static class PartitionFiles {
        private final List<DataFileMeta> files = new ArrayList<DataFileMeta>();
        private long totalSize = 0L;

        private PartitionFiles() {
        }

        private void addFile(DataFileMeta file) {
            this.files.add(file);
            this.totalSize += file.fileSize();
        }
    }
}

