/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.KeyValueFileReaderFactory;
import org.apache.paimon.mergetree.DropDeleteReader;
import org.apache.paimon.mergetree.MergeSorter;
import org.apache.paimon.mergetree.MergeTreeReaders;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.ConcatRecordReader;
import org.apache.paimon.mergetree.compact.IntervalPartition;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.ReducerMergeFunctionWrapper;
import org.apache.paimon.operation.SplitRead;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.DeletionFile;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.UserDefinedSeqComparator;

public class MergeFileSplitRead
implements SplitRead<KeyValue> {
    private final TableSchema tableSchema;
    private final FileIO fileIO;
    private final KeyValueFileReaderFactory.Builder readerFactoryBuilder;
    private final Comparator<InternalRow> keyComparator;
    private final MergeFunctionFactory<KeyValue> mfFactory;
    private final MergeSorter mergeSorter;
    private final List<String> sequenceFields;
    private final boolean sequenceOrder;
    @Nullable
    private RowType readKeyType;
    @Nullable
    private List<Predicate> filtersForKeys;
    @Nullable
    private List<Predicate> filtersForAll;
    @Nullable
    private int[][] pushdownProjection;
    @Nullable
    private int[][] outerProjection;
    private boolean forceKeepDelete = false;

    public MergeFileSplitRead(CoreOptions options, TableSchema schema, RowType keyType, RowType valueType, Comparator<InternalRow> keyComparator, MergeFunctionFactory<KeyValue> mfFactory, KeyValueFileReaderFactory.Builder readerFactoryBuilder) {
        this.tableSchema = schema;
        this.readerFactoryBuilder = readerFactoryBuilder;
        this.fileIO = readerFactoryBuilder.fileIO();
        this.keyComparator = keyComparator;
        this.mfFactory = mfFactory;
        this.mergeSorter = new MergeSorter(CoreOptions.fromMap(this.tableSchema.options()), keyType, valueType, null);
        this.sequenceFields = options.sequenceField();
        this.sequenceOrder = options.sequenceFieldSortOrderIsAscending();
    }

    public Comparator<InternalRow> keyComparator() {
        return this.keyComparator;
    }

    public MergeSorter mergeSorter() {
        return this.mergeSorter;
    }

    public TableSchema tableSchema() {
        return this.tableSchema;
    }

    public MergeFileSplitRead withReadKeyType(RowType readKeyType) {
        this.readerFactoryBuilder.withReadKeyType(readKeyType);
        this.readKeyType = readKeyType;
        return this;
    }

    /*
     * Exception decompiling
     */
    public MergeFileSplitRead withReadType(RowType readType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AssignmentExpression.applyExpressionRewriter(AssignmentExpression.java:68)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public MergeFileSplitRead withIOManager(IOManager ioManager) {
        this.mergeSorter.setIOManager(ioManager);
        return this;
    }

    public MergeFileSplitRead forceKeepDelete() {
        this.forceKeepDelete = true;
        return this;
    }

    public MergeFileSplitRead withFilter(Predicate predicate) {
        if (predicate == null) {
            return this;
        }
        ArrayList<Predicate> allFilters = new ArrayList<Predicate>();
        ArrayList<Predicate> pkFilters = null;
        List<String> primaryKeys = this.tableSchema.trimmedPrimaryKeys();
        Set<String> nonPrimaryKeys = this.tableSchema.fieldNames().stream().filter(name -> !primaryKeys.contains(name)).collect(Collectors.toSet());
        for (Predicate sub : PredicateBuilder.splitAnd(predicate)) {
            allFilters.add(sub);
            if (PredicateBuilder.containsFields(sub, nonPrimaryKeys)) continue;
            if (pkFilters == null) {
                pkFilters = new ArrayList<Predicate>();
            }
            pkFilters.add(sub);
        }
        this.filtersForAll = allFilters;
        this.filtersForKeys = pkFilters;
        return this;
    }

    @Override
    public RecordReader<KeyValue> createReader(DataSplit split) throws IOException {
        if (!split.beforeFiles().isEmpty()) {
            throw new IllegalArgumentException("This read cannot accept split with before files.");
        }
        if (split.isStreaming() || split.bucket() == -2) {
            return this.createNoMergeReader(split.partition(), split.bucket(), split.dataFiles(), split.deletionFiles().orElse(null), split.isStreaming());
        }
        return this.createMergeReader(split.partition(), split.bucket(), split.dataFiles(), split.deletionFiles().orElse(null), this.forceKeepDelete);
    }

    public RecordReader<KeyValue> createMergeReader(BinaryRow partition, int bucket, List<DataFileMeta> files, @Nullable List<DeletionFile> deletionFiles, boolean keepDelete) throws IOException {
        DeletionVector.Factory dvFactory = DeletionVector.factory(this.fileIO, files, deletionFiles);
        KeyValueFileReaderFactory overlappedSectionFactory = this.readerFactoryBuilder.build(partition, bucket, dvFactory, false, this.filtersForKeys);
        KeyValueFileReaderFactory nonOverlappedSectionFactory = this.readerFactoryBuilder.build(partition, bucket, dvFactory, false, this.filtersForAll);
        ArrayList sectionReaders = new ArrayList();
        ReducerMergeFunctionWrapper mergeFuncWrapper = new ReducerMergeFunctionWrapper(this.mfFactory.create(this.pushdownProjection));
        for (List<SortedRun> section : new IntervalPartition(files, this.keyComparator).partition()) {
            sectionReaders.add(() -> MergeTreeReaders.readerForSection(section, section.size() > 1 ? overlappedSectionFactory : nonOverlappedSectionFactory, this.keyComparator, this.createUdsComparator(), mergeFuncWrapper, this.mergeSorter));
        }
        DropDeleteReader reader = ConcatRecordReader.create(sectionReaders);
        if (!keepDelete) {
            reader = new DropDeleteReader(reader);
        }
        return this.projectOuter(this.projectKey(reader));
    }

    public RecordReader<KeyValue> createNoMergeReader(BinaryRow partition, int bucket, List<DataFileMeta> files, @Nullable List<DeletionFile> deletionFiles, boolean onlyFilterKey) throws IOException {
        KeyValueFileReaderFactory readerFactory = this.readerFactoryBuilder.build(partition, bucket, DeletionVector.factory(this.fileIO, files, deletionFiles), true, onlyFilterKey ? this.filtersForKeys : this.filtersForAll);
        ArrayList suppliers = new ArrayList();
        for (DataFileMeta file : files) {
            suppliers.add(() -> readerFactory.createRecordReader(file));
        }
        return this.projectOuter(ConcatRecordReader.create(suppliers));
    }

    private RecordReader<KeyValue> projectKey(RecordReader<KeyValue> reader) {
        if (this.readKeyType == null) {
            return reader;
        }
        ProjectedRow projectedRow = ProjectedRow.from(this.readKeyType, this.tableSchema.logicalRowType());
        return reader.transform(kv -> kv.replaceKey(projectedRow.replaceRow(kv.key())));
    }

    private RecordReader<KeyValue> projectOuter(RecordReader<KeyValue> reader) {
        if (this.outerProjection != null) {
            ProjectedRow projectedRow = ProjectedRow.from(this.outerProjection);
            reader = reader.transform(kv -> kv.replaceValue(projectedRow.replaceRow(kv.value())));
        }
        return reader;
    }

    @Nullable
    public UserDefinedSeqComparator createUdsComparator() {
        return UserDefinedSeqComparator.create(this.readerFactoryBuilder.readValueType(), this.sequenceFields, this.sequenceOrder);
    }

    private static /* synthetic */ boolean lambda$withReadType$4(DataField requiredField, DataField x) {
        return x.name().equals(requiredField.name());
    }

    private static /* synthetic */ int lambda$withReadType$3(int[] arr) {
        return arr[0];
    }

    private static /* synthetic */ boolean lambda$withReadType$2(List projectedNames, String f) {
        return !projectedNames.contains(f);
    }

    private static /* synthetic */ int[][] lambda$withReadType$1(int x$0) {
        return new int[x$0][];
    }
}

