/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.paimon.AbstractFileStore;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.BucketedDvMaintainer;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.index.DynamicBucketIndexMaintainer;
import org.apache.paimon.io.KeyValueFileReaderFactory;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.operation.AbstractFileStoreWrite;
import org.apache.paimon.operation.BucketSelectConverter;
import org.apache.paimon.operation.KeyValueFileStoreScan;
import org.apache.paimon.operation.KeyValueFileStoreWrite;
import org.apache.paimon.operation.MergeFileSplitRead;
import org.apache.paimon.operation.RawFileSplitRead;
import org.apache.paimon.postpone.PostponeBucketFileStoreWrite;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.KeyComparatorSupplier;
import org.apache.paimon.utils.UserDefinedSeqComparator;
import org.apache.paimon.utils.ValueEqualiserSupplier;

public class KeyValueFileStore
extends AbstractFileStore<KeyValue> {
    private final boolean crossPartitionUpdate;
    private final RowType bucketKeyType;
    private final RowType keyType;
    private final RowType valueType;
    private final KeyValueFieldsExtractor keyValueFieldsExtractor;
    private final Supplier<Comparator<InternalRow>> keyComparatorSupplier;
    private final Supplier<RecordEqualiser> logDedupEqualSupplier;
    private final MergeFunctionFactory<KeyValue> mfFactory;

    public KeyValueFileStore(FileIO fileIO, SchemaManager schemaManager, TableSchema schema, boolean crossPartitionUpdate, CoreOptions options, RowType partitionType, RowType bucketKeyType, RowType keyType, RowType valueType, KeyValueFieldsExtractor keyValueFieldsExtractor, MergeFunctionFactory<KeyValue> mfFactory, String tableName, CatalogEnvironment catalogEnvironment) {
        super(fileIO, schemaManager, schema, tableName, options, partitionType, catalogEnvironment);
        this.crossPartitionUpdate = crossPartitionUpdate;
        this.bucketKeyType = bucketKeyType;
        this.keyType = keyType;
        this.valueType = valueType;
        this.keyValueFieldsExtractor = keyValueFieldsExtractor;
        this.mfFactory = mfFactory;
        this.keyComparatorSupplier = new KeyComparatorSupplier(keyType);
        List<String> logDedupIgnoreFields = options.changelogRowDeduplicateIgnoreFields();
        this.logDedupEqualSupplier = options.changelogRowDeduplicate() ? ValueEqualiserSupplier.fromIgnoreFields(valueType, logDedupIgnoreFields) : () -> null;
    }

    @Override
    public BucketMode bucketMode() {
        int bucket = this.options.bucket();
        switch (bucket) {
            case -2: {
                return BucketMode.POSTPONE_MODE;
            }
            case -1: {
                return this.crossPartitionUpdate ? BucketMode.KEY_DYNAMIC : BucketMode.HASH_DYNAMIC;
            }
        }
        return BucketMode.HASH_FIXED;
    }

    public MergeFileSplitRead newRead() {
        return new MergeFileSplitRead(this.options, this.schema, this.keyType, this.valueType, this.newKeyComparator(), this.mfFactory, this.newReaderFactoryBuilder());
    }

    public RawFileSplitRead newBatchRawFileRead() {
        return new RawFileSplitRead(this.fileIO, this.schemaManager, this.schema, this.valueType, FileFormatDiscover.of(this.options), this.pathFactory(), this.options.fileIndexReadEnabled(), false);
    }

    public KeyValueFileReaderFactory.Builder newReaderFactoryBuilder() {
        return KeyValueFileReaderFactory.builder(this.fileIO, this.schemaManager, this.schema, this.keyType, this.valueType, FileFormatDiscover.of(this.options), this.pathFactory(), this.keyValueFieldsExtractor, this.options);
    }

    @Override
    public AbstractFileStoreWrite<KeyValue> newWrite(String commitUser) {
        return this.newWrite(commitUser, null);
    }

    @Override
    public AbstractFileStoreWrite<KeyValue> newWrite(String commitUser, @Nullable Integer writeId) {
        if (this.options.bucket() == -2) {
            return new PostponeBucketFileStoreWrite(this.fileIO, this.pathFactory(), this.schema, commitUser, this.partitionType, this.keyType, this.valueType, this.mfFactory, this::pathFactory, this.newReaderFactoryBuilder(), this.snapshotManager(), this.newScan(), this.options, this.tableName, writeId);
        }
        DynamicBucketIndexMaintainer.Factory indexFactory = null;
        if (this.bucketMode() == BucketMode.HASH_DYNAMIC) {
            indexFactory = new DynamicBucketIndexMaintainer.Factory(this.newIndexFileHandler());
        }
        BucketedDvMaintainer.Factory dvMaintainerFactory = null;
        if (this.options.deletionVectorsEnabled()) {
            dvMaintainerFactory = BucketedDvMaintainer.factory(this.newIndexFileHandler());
        }
        return new KeyValueFileStoreWrite(this.fileIO, this.schemaManager, this.schema, commitUser, this.partitionType, this.keyType, this.valueType, this.keyComparatorSupplier, () -> UserDefinedSeqComparator.create(this.valueType, this.options), this.logDedupEqualSupplier, this.mfFactory, this.pathFactory(), this::pathFactory, this.snapshotManager(), this.newScan(), indexFactory, dvMaintainerFactory, this.options, this.keyValueFieldsExtractor, this.tableName);
    }

    @Override
    public KeyValueFileStoreScan newScan() {
        BucketMode bucketMode = this.bucketMode();
        BucketSelectConverter bucketSelectConverter = keyFilter -> {
            if (bucketMode != BucketMode.HASH_FIXED && bucketMode != BucketMode.POSTPONE_MODE) {
                return Optional.empty();
            }
            List<Predicate> bucketFilters = PredicateBuilder.pickTransformFieldMapping(PredicateBuilder.splitAnd(keyFilter), this.keyType.getFieldNames(), this.bucketKeyType.getFieldNames());
            if (!bucketFilters.isEmpty()) {
                return BucketSelectConverter.create(PredicateBuilder.and(bucketFilters), this.bucketKeyType, this.options.bucketFunctionType());
            }
            return Optional.empty();
        };
        return new KeyValueFileStoreScan(this.newManifestsReader(), bucketSelectConverter, this.snapshotManager(), this.schemaManager, this.schema, this.keyValueFieldsExtractor, this.manifestFileFactory(), this.options.scanManifestParallelism(), this.options.deletionVectorsEnabled(), this.options.mergeEngine(), this.options.changelogProducer(), this.options.fileIndexReadEnabled() && this.options.deletionVectorsEnabled());
    }

    @Override
    public Comparator<InternalRow> newKeyComparator() {
        return this.keyComparatorSupplier.get();
    }
}

