/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.paimon.fileindex.FileIndexFormat;
import org.apache.paimon.fileindex.FileIndexReader;
import org.apache.paimon.fileindex.FileIndexResult;
import org.apache.paimon.fileindex.bitmap.BitmapIndexResult;
import org.apache.paimon.fs.ByteArraySeekableStream;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.predicate.CompoundPredicate;
import org.apache.paimon.predicate.FieldRef;
import org.apache.paimon.predicate.LeafPredicate;
import org.apache.paimon.predicate.Or;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateVisitor;
import org.apache.paimon.predicate.SortValue;
import org.apache.paimon.predicate.TopN;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.RoaringBitmap32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIndexPredicate
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(FileIndexPredicate.class);
    private final FileIndexFormat.Reader reader;
    @Nullable
    private Path path;

    public FileIndexPredicate(Path path, FileIO fileIO, RowType fileRowType) throws IOException {
        this(fileIO.newInputStream(path), fileRowType);
        this.path = path;
    }

    public FileIndexPredicate(byte[] serializedBytes, RowType fileRowType) {
        this(new ByteArraySeekableStream(serializedBytes), fileRowType);
    }

    public FileIndexPredicate(SeekableInputStream inputStream, RowType fileRowType) {
        this.reader = FileIndexFormat.createReader(inputStream, fileRowType);
    }

    public FileIndexResult evaluate(@Nullable Predicate predicate) {
        if (predicate == null) {
            return FileIndexResult.REMAIN;
        }
        Set<String> requiredFieldNames = this.getRequiredNames(predicate);
        HashMap<String, Collection<FileIndexReader>> indexReaders = new HashMap<String, Collection<FileIndexReader>>();
        requiredFieldNames.forEach(name -> {
            Collection cfr_ignored_0 = indexReaders.put((String)name, (Collection<FileIndexReader>)this.reader.readColumnIndex((String)name));
        });
        FileIndexResult result = new FileIndexPredicateTest(indexReaders).test(predicate);
        if (!result.remain()) {
            LOG.debug("One file has been filtered: " + (this.path == null ? "in scan stage" : this.path.toString()));
        }
        return result;
    }

    public FileIndexResult evaluateTopN(@Nullable TopN topN, FileIndexResult result) {
        long cardinality;
        if (topN == null || !result.remain()) {
            return result;
        }
        int k = topN.limit();
        if (result instanceof BitmapIndexResult && (cardinality = ((RoaringBitmap32)((BitmapIndexResult)result).get()).getCardinality()) <= (long)k) {
            return result;
        }
        List<SortValue> orders = topN.orders();
        String requiredName = orders.get(0).field().name();
        Set<FileIndexReader> readers = this.reader.readColumnIndex(requiredName);
        for (FileIndexReader reader : readers) {
            FileIndexResult ret = reader.visitTopN(topN, result);
            if (FileIndexResult.REMAIN.equals(ret)) continue;
            ret.remain();
            return ret;
        }
        return result;
    }

    private Set<String> getRequiredNames(Predicate filePredicate) {
        return filePredicate.visit(new PredicateVisitor<Set<String>>(){
            final Set<String> names = new HashSet<String>();

            @Override
            public Set<String> visit(LeafPredicate predicate) {
                this.names.add(predicate.fieldName());
                return this.names;
            }

            @Override
            public Set<String> visit(CompoundPredicate predicate) {
                for (Predicate child : predicate.children()) {
                    child.visit(this);
                }
                return this.names;
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private static class FileIndexPredicateTest
    implements PredicateVisitor<FileIndexResult> {
        private final Map<String, Collection<FileIndexReader>> columnIndexReaders;

        public FileIndexPredicateTest(Map<String, Collection<FileIndexReader>> fileIndexReaders) {
            this.columnIndexReaders = fileIndexReaders;
        }

        public FileIndexResult test(Predicate predicate) {
            return predicate.visit(this);
        }

        @Override
        public FileIndexResult visit(LeafPredicate predicate) {
            FileIndexResult compoundResult = FileIndexResult.REMAIN;
            FieldRef fieldRef = new FieldRef(predicate.index(), predicate.fieldName(), predicate.type());
            for (FileIndexReader fileIndexReader : this.columnIndexReaders.get(predicate.fieldName())) {
                if ((compoundResult = compoundResult.and(predicate.function().visit(fileIndexReader, fieldRef, predicate.literals()))).remain()) continue;
                return compoundResult;
            }
            return compoundResult;
        }

        @Override
        public FileIndexResult visit(CompoundPredicate predicate) {
            if (predicate.function() instanceof Or) {
                FileIndexResult compoundResult = null;
                for (Predicate predicate1 : predicate.children()) {
                    compoundResult = compoundResult == null ? predicate1.visit(this) : compoundResult.or(predicate1.visit(this));
                }
                return compoundResult == null ? FileIndexResult.REMAIN : compoundResult;
            }
            FileIndexResult compoundResult = null;
            for (Predicate predicate1 : predicate.children()) {
                if ((compoundResult = compoundResult == null ? predicate1.visit(this) : compoundResult.and(predicate1.visit(this))).remain()) continue;
                return compoundResult;
            }
            return compoundResult == null ? FileIndexResult.REMAIN : compoundResult;
        }
    }
}

