/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.metadata;

import java.io.IOException;
import org.apache.paimon.iceberg.metadata.IcebergListType;
import org.apache.paimon.iceberg.metadata.IcebergMapType;
import org.apache.paimon.iceberg.metadata.IcebergStructType;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;

public class IcebergDataTypeDeserializer
extends JsonDeserializer<Object> {
    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectCodec mapper = p.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(p);
        if (node.isTextual()) {
            return node.asText();
        }
        if (node.isObject()) {
            String type;
            if (!node.has("type")) {
                throw new IOException("Exception occurs when deserialize iceberg data field. Missing 'type' field: " + node);
            }
            switch (type = node.get("type").asText()) {
                case "map": {
                    return mapper.treeToValue(node, IcebergMapType.class);
                }
                case "list": {
                    return mapper.treeToValue(node, IcebergListType.class);
                }
                case "struct": {
                    return mapper.treeToValue(node, IcebergStructType.class);
                }
            }
            throw new IOException("Exception occurs when deserialize iceberg data field. Unknown iceberg field type: " + type);
        }
        throw new IOException("Unexpected json node. node type: " + (Object)((Object)node.getNodeType()));
    }
}

