/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.SimpleColStats;
import org.apache.paimon.format.SimpleStatsCollector;
import org.apache.paimon.format.SimpleStatsExtractor;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;

public interface SimpleStatsProducer {
    public boolean isStatsDisabled();

    public boolean requirePerRecord();

    public void collect(InternalRow var1);

    public SimpleColStats[] extract(FileIO var1, Path var2, long var3) throws IOException;

    public static SimpleStatsProducer disabledProducer() {
        return new SimpleStatsProducer(){

            @Override
            public boolean isStatsDisabled() {
                return true;
            }

            @Override
            public boolean requirePerRecord() {
                return false;
            }

            @Override
            public void collect(InternalRow row) {
                throw new IllegalStateException();
            }

            @Override
            public SimpleColStats[] extract(FileIO fileIO, Path path, long length) {
                throw new IllegalStateException();
            }
        };
    }

    public static SimpleStatsProducer fromExtractor(final @Nullable SimpleStatsExtractor extractor) {
        if (extractor == null) {
            return SimpleStatsProducer.disabledProducer();
        }
        return new SimpleStatsProducer(){

            @Override
            public boolean isStatsDisabled() {
                return false;
            }

            @Override
            public boolean requirePerRecord() {
                return false;
            }

            @Override
            public void collect(InternalRow row) {
                throw new IllegalStateException();
            }

            @Override
            public SimpleColStats[] extract(FileIO fileIO, Path path, long length) throws IOException {
                return extractor.extract(fileIO, path, length);
            }
        };
    }

    public static SimpleStatsProducer fromCollector(final SimpleStatsCollector collector) {
        if (collector.isDisabled()) {
            return SimpleStatsProducer.disabledProducer();
        }
        return new SimpleStatsProducer(){

            @Override
            public boolean isStatsDisabled() {
                return collector.isDisabled();
            }

            @Override
            public boolean requirePerRecord() {
                return true;
            }

            @Override
            public void collect(InternalRow row) {
                collector.collect(row);
            }

            @Override
            public SimpleColStats[] extract(FileIO fileIO, Path path, long length) {
                return collector.extract();
            }
        };
    }
}

