/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.SimpleStatsCollector;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.io.SingleFileWriter;
import org.apache.paimon.manifest.BucketFilter;
import org.apache.paimon.manifest.ExpireFileEntry;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestEntryCache;
import org.apache.paimon.manifest.ManifestEntryFilters;
import org.apache.paimon.manifest.ManifestEntrySerializer;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.operation.metrics.CacheMetrics;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.stats.SimpleStatsConverter;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.ObjectsFile;
import org.apache.paimon.utils.PathFactory;
import org.apache.paimon.utils.SegmentsCache;
import org.apache.paimon.utils.VersionedObjectSerializer;

public class ManifestFile
extends ObjectsFile<ManifestEntry> {
    private final SchemaManager schemaManager;
    private final RowType partitionType;
    private final FormatWriterFactory writerFactory;
    private final long suggestedFileSize;

    private ManifestFile(FileIO fileIO, SchemaManager schemaManager, RowType partitionType, ManifestEntrySerializer serializer, RowType schema, FormatReaderFactory readerFactory, FormatWriterFactory writerFactory, String compression, PathFactory pathFactory, long suggestedFileSize, @Nullable SegmentsCache<Path> cache) {
        super(fileIO, serializer, schema, readerFactory, writerFactory, compression, pathFactory, cache);
        this.schemaManager = schemaManager;
        this.partitionType = partitionType;
        this.writerFactory = writerFactory;
        this.suggestedFileSize = suggestedFileSize;
    }

    protected ManifestEntryCache createCache(@Nullable SegmentsCache<Path> cache, RowType formatType) {
        return new ManifestEntryCache(cache, this.serializer, formatType, x$0 -> super.fileSize((Path)x$0), (x$0, x$1) -> super.createIterator((Path)x$0, (Long)x$1));
    }

    public ManifestFile withCacheMetrics(@Nullable CacheMetrics cacheMetrics) {
        super.withCacheMetrics(cacheMetrics);
        return this;
    }

    public List<ManifestEntry> read(String fileName, @Nullable Long fileSize, @Nullable PartitionPredicate partitionFilter, @Nullable BucketFilter bucketFilter, Filter<InternalRow> readFilter, Filter<ManifestEntry> readTFilter) {
        try {
            Path path = this.pathFactory.toPath(fileName);
            if (this.cache != null) {
                return this.cache.read(path, fileSize, new ManifestEntryFilters(partitionFilter, bucketFilter, readFilter, readTFilter));
            }
            return ManifestFile.readFromIterator(this.createIterator(path, fileSize), this.serializer, readFilter, readTFilter);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @VisibleForTesting
    public long suggestedFileSize() {
        return this.suggestedFileSize;
    }

    public List<ExpireFileEntry> readExpireFileEntries(String fileName, @Nullable Long fileSize) {
        List entries = this.read(fileName, fileSize);
        ArrayList<ExpireFileEntry> result = new ArrayList<ExpireFileEntry>(entries.size());
        for (ManifestEntry entry : entries) {
            result.add(ExpireFileEntry.from(entry));
        }
        return result;
    }

    public List<ManifestFileMeta> write(List<ManifestEntry> entries) {
        RollingFileWriter<ManifestEntry, ManifestFileMeta> writer = this.createRollingWriter();
        try {
            writer.write((ManifestEntry)((Object)entries));
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return writer.result();
    }

    public RollingFileWriter<ManifestEntry, ManifestFileMeta> createRollingWriter() {
        return new RollingFileWriter<ManifestEntry, ManifestFileMeta>(() -> new ManifestEntryWriter(this.writerFactory, this.pathFactory.newPath(), this.compression), this.suggestedFileSize);
    }

    public ManifestEntryWriter createManifestEntryWriter(Path manifestPath) {
        return new ManifestEntryWriter(this.writerFactory, manifestPath, this.compression);
    }

    public static class Factory {
        private final FileIO fileIO;
        private final SchemaManager schemaManager;
        private final RowType partitionType;
        private final FileFormat fileFormat;
        private final String compression;
        private final FileStorePathFactory pathFactory;
        private final long suggestedFileSize;
        @Nullable
        private final SegmentsCache<Path> cache;

        public Factory(FileIO fileIO, SchemaManager schemaManager, RowType partitionType, FileFormat fileFormat, String compression, FileStorePathFactory pathFactory, long suggestedFileSize, @Nullable SegmentsCache<Path> cache) {
            this.fileIO = fileIO;
            this.schemaManager = schemaManager;
            this.partitionType = partitionType;
            this.fileFormat = fileFormat;
            this.compression = compression;
            this.pathFactory = pathFactory;
            this.suggestedFileSize = suggestedFileSize;
            this.cache = cache;
        }

        public boolean isCacheEnabled() {
            return this.cache != null;
        }

        public ManifestFile create() {
            RowType entryType = VersionedObjectSerializer.versionType(ManifestEntry.SCHEMA);
            return new ManifestFile(this.fileIO, this.schemaManager, this.partitionType, new ManifestEntrySerializer(), entryType, this.fileFormat.createReaderFactory(entryType, entryType, new ArrayList<Predicate>()), this.fileFormat.createWriterFactory(entryType), this.compression, this.pathFactory.manifestFileFactory(), this.suggestedFileSize, this.cache);
        }
    }

    public class ManifestEntryWriter
    extends SingleFileWriter<ManifestEntry, ManifestFileMeta> {
        private final SimpleStatsCollector partitionStatsCollector;
        private final SimpleStatsConverter partitionStatsSerializer;
        private long numAddedFiles;
        private long numDeletedFiles;
        private long schemaId;
        private int minBucket;
        private int maxBucket;
        private int minLevel;
        private int maxLevel;

        ManifestEntryWriter(FormatWriterFactory factory, Path path, String fileCompression) {
            super(ManifestFile.this.fileIO, factory, path, ManifestFile.this.serializer::toRow, fileCompression, false);
            this.numAddedFiles = 0L;
            this.numDeletedFiles = 0L;
            this.schemaId = Long.MIN_VALUE;
            this.minBucket = Integer.MAX_VALUE;
            this.maxBucket = Integer.MIN_VALUE;
            this.minLevel = Integer.MAX_VALUE;
            this.maxLevel = Integer.MIN_VALUE;
            this.partitionStatsCollector = new SimpleStatsCollector(ManifestFile.this.partitionType);
            this.partitionStatsSerializer = new SimpleStatsConverter(ManifestFile.this.partitionType);
        }

        @Override
        public void write(ManifestEntry entry) throws IOException {
            super.write(entry);
            switch (entry.kind()) {
                case ADD: {
                    ++this.numAddedFiles;
                    break;
                }
                case DELETE: {
                    ++this.numDeletedFiles;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown entry kind: " + (Object)((Object)entry.kind()));
                }
            }
            this.schemaId = Math.max(this.schemaId, entry.file().schemaId());
            this.minBucket = Math.min(this.minBucket, entry.bucket());
            this.maxBucket = Math.max(this.maxBucket, entry.bucket());
            this.minLevel = Math.min(this.minLevel, entry.level());
            this.maxLevel = Math.max(this.maxLevel, entry.level());
            this.partitionStatsCollector.collect(entry.partition());
        }

        @Override
        public ManifestFileMeta result() throws IOException {
            return new ManifestFileMeta(this.path.getName(), this.outputBytes, this.numAddedFiles, this.numDeletedFiles, this.partitionStatsSerializer.toBinaryAllMode(this.partitionStatsCollector.extract()), this.numAddedFiles + this.numDeletedFiles > 0L ? this.schemaId : ManifestFile.this.schemaManager.latest().get().id(), this.minBucket, this.maxBucket, this.minLevel, this.maxLevel);
        }
    }
}

