/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;

public class OffPeakHours {
    private final int startHour;
    private final int endHour;
    private final int compactOffPeakRatio;

    private OffPeakHours(int startHour, int endHour, int compactOffPeakRatio) {
        this.startHour = startHour;
        this.endHour = endHour;
        this.compactOffPeakRatio = compactOffPeakRatio;
    }

    public int currentRatio(int targetHour) {
        boolean isOffPeak = this.startHour <= this.endHour ? this.startHour <= targetHour && targetHour < this.endHour : targetHour < this.endHour || this.startHour <= targetHour;
        return isOffPeak ? this.compactOffPeakRatio : 0;
    }

    @Nullable
    public static OffPeakHours create(CoreOptions options) {
        return OffPeakHours.create(options.compactOffPeakStartHour(), options.compactOffPeakEndHour(), options.compactOffPeakRatio());
    }

    public static OffPeakHours create(int startHour, int endHour, int compactOffPeakRatio) {
        if (startHour == -1 || endHour == -1) {
            return null;
        }
        if (startHour == endHour) {
            return null;
        }
        return new OffPeakHours(startHour, endHour, compactOffPeakRatio);
    }
}

