/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.parquet.column.statistics;

import org.apache.paimon.shade.org.apache.parquet.bytes.BytesUtils;
import org.apache.paimon.shade.org.apache.parquet.column.statistics.Statistics;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;
import org.apache.paimon.shade.org.apache.parquet.schema.Types;

public class IntStatistics
extends Statistics<Integer> {
    private static final PrimitiveType DEFAULT_FAKE_TYPE = (PrimitiveType)Types.optional(PrimitiveType.PrimitiveTypeName.INT32).named("fake_int32_type");
    private int max;
    private int min;

    @Deprecated
    public IntStatistics() {
        this(DEFAULT_FAKE_TYPE);
    }

    IntStatistics(PrimitiveType type) {
        super(type);
    }

    private IntStatistics(IntStatistics other) {
        super(other.type());
        if (other.hasNonNullValue()) {
            this.initializeStats(other.min, other.max);
        }
        this.setNumNulls(other.getNumNulls());
    }

    @Override
    public void updateStats(int value) {
        if (!this.hasNonNullValue()) {
            this.initializeStats(value, value);
        } else {
            this.updateStats(value, value);
        }
    }

    @Override
    public void mergeStatisticsMinMax(Statistics stats) {
        IntStatistics intStats = (IntStatistics)stats;
        if (!this.hasNonNullValue()) {
            this.initializeStats(intStats.getMin(), intStats.getMax());
        } else {
            this.updateStats(intStats.getMin(), intStats.getMax());
        }
    }

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
        this.max = BytesUtils.bytesToInt(maxBytes);
        this.min = BytesUtils.bytesToInt(minBytes);
        this.markAsNotEmpty();
    }

    @Override
    public byte[] getMaxBytes() {
        return BytesUtils.intToBytes(this.max);
    }

    @Override
    public byte[] getMinBytes() {
        return BytesUtils.intToBytes(this.min);
    }

    @Override
    String stringify(Integer value) {
        return this.stringifier.stringify(value);
    }

    @Override
    public boolean isSmallerThan(long size) {
        return !this.hasNonNullValue() || 8L < size;
    }

    public void updateStats(int min_value, int max_value) {
        if (this.comparator().compare(this.min, min_value) > 0) {
            this.min = min_value;
        }
        if (this.comparator().compare(this.max, max_value) < 0) {
            this.max = max_value;
        }
    }

    public void initializeStats(int min_value, int max_value) {
        this.min = min_value;
        this.max = max_value;
        this.markAsNotEmpty();
    }

    @Override
    public Integer genericGetMin() {
        return this.min;
    }

    @Override
    public Integer genericGetMax() {
        return this.max;
    }

    @Override
    public int compareMinToValue(int value) {
        return this.comparator().compare(this.min, value);
    }

    @Override
    public int compareMaxToValue(int value) {
        return this.comparator().compare(this.max, value);
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMinMax(int min, int max) {
        this.max = max;
        this.min = min;
        this.markAsNotEmpty();
    }

    public IntStatistics copy() {
        return new IntStatistics(this);
    }
}

