/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.CommitCallback;
import org.apache.paimon.table.sink.TagCallback;
import org.apache.paimon.utils.Preconditions;

public class CallbackUtils {
    public static List<TagCallback> loadTagCallbacks(CoreOptions coreOptions) {
        return CallbackUtils.loadCallbacks(coreOptions.tagCallbacks(), TagCallback.class);
    }

    public static List<CommitCallback> loadCommitCallbacks(CoreOptions coreOptions, FileStoreTable table) {
        List<CommitCallback> commitCallbacks = CallbackUtils.loadCallbacks(coreOptions.commitCallbacks(), CommitCallback.class);
        commitCallbacks.forEach(callback -> callback.setTable(table));
        return commitCallbacks;
    }

    private static <T> List<T> loadCallbacks(Map<String, String> clazzParamMaps, Class<T> expectClass) {
        ArrayList result = new ArrayList();
        for (Map.Entry<String, String> classParamEntry : clazzParamMaps.entrySet()) {
            Class<?> clazz;
            String className = classParamEntry.getKey();
            String param = classParamEntry.getValue();
            try {
                clazz = Class.forName(className, true, CallbackUtils.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            Preconditions.checkArgument(expectClass.isAssignableFrom(clazz), "Class " + clazz + " must implement " + expectClass);
            try {
                if (param == null) {
                    result.add(clazz.newInstance());
                    continue;
                }
                result.add(clazz.getConstructor(String.class).newInstance(param));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize commit callback " + className + (param == null ? "" : " with param " + param), e);
            }
        }
        return result;
    }
}

