/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.casting.DefaultValueRow;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.io.BundleRecords;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.memory.MemoryPoolFactory;
import org.apache.paimon.metrics.MetricRegistry;
import org.apache.paimon.operation.BundleFileStoreWriter;
import org.apache.paimon.operation.FileStoreWrite;
import org.apache.paimon.operation.WriteRestore;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.InnerTableWrite;
import org.apache.paimon.table.sink.KeyAndBucketExtractor;
import org.apache.paimon.table.sink.RowKindGenerator;
import org.apache.paimon.table.sink.SinkRecord;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.Restorable;
import org.apache.paimon.utils.RowKindFilter;

public class TableWriteImpl<T>
implements InnerTableWrite,
Restorable<List<FileStoreWrite.State<T>>> {
    private final FileStoreWrite<T> write;
    private final KeyAndBucketExtractor<InternalRow> keyAndBucketExtractor;
    private final RecordExtractor<T> recordExtractor;
    @Nullable
    private final RowKindGenerator rowKindGenerator;
    @Nullable
    private final RowKindFilter rowKindFilter;
    private boolean batchCommitted = false;
    private BucketMode bucketMode;
    private RowType writeType;
    private int[] notNullFieldIndex;
    @Nullable
    private final DefaultValueRow defaultValueRow;

    public TableWriteImpl(RowType rowType, FileStoreWrite<T> write, KeyAndBucketExtractor<InternalRow> keyAndBucketExtractor, RecordExtractor<T> recordExtractor, @Nullable RowKindGenerator rowKindGenerator, @Nullable RowKindFilter rowKindFilter) {
        this.writeType = rowType;
        this.write = write;
        this.keyAndBucketExtractor = keyAndBucketExtractor;
        this.recordExtractor = recordExtractor;
        this.rowKindGenerator = rowKindGenerator;
        this.rowKindFilter = rowKindFilter;
        List<String> notNullColumnNames = rowType.getFields().stream().filter(field -> !field.type().isNullable()).map(DataField::name).collect(Collectors.toList());
        this.notNullFieldIndex = rowType.getFieldIndices(notNullColumnNames);
        this.defaultValueRow = DefaultValueRow.create(rowType);
    }

    public FileStoreWrite<T> fileStoreWrite() {
        return this.write;
    }

    @Override
    public InnerTableWrite withWriteRestore(WriteRestore writeRestore) {
        this.write.withWriteRestore(writeRestore);
        return this;
    }

    @Override
    public TableWriteImpl<T> withIgnorePreviousFiles(boolean ignorePreviousFiles) {
        this.write.withIgnorePreviousFiles(ignorePreviousFiles);
        return this;
    }

    @Override
    public TableWriteImpl<T> withIOManager(IOManager ioManager) {
        this.write.withIOManager(ioManager);
        return this;
    }

    @Override
    public TableWriteImpl<T> withWriteType(RowType writeType) {
        this.write.withWriteType(writeType);
        this.writeType = writeType;
        List<String> notNullColumnNames = writeType.getFields().stream().filter(field -> !field.type().isNullable()).map(DataField::name).collect(Collectors.toList());
        this.notNullFieldIndex = writeType.getFieldIndices(notNullColumnNames);
        return this;
    }

    @Override
    public TableWriteImpl<T> withMemoryPoolFactory(MemoryPoolFactory memoryPoolFactory) {
        this.write.withMemoryPoolFactory(memoryPoolFactory);
        return this;
    }

    public TableWriteImpl<T> withCompactExecutor(ExecutorService compactExecutor) {
        this.write.withCompactExecutor(compactExecutor);
        return this;
    }

    public TableWriteImpl<T> withBucketMode(BucketMode bucketMode) {
        this.bucketMode = bucketMode;
        return this;
    }

    @Override
    public BinaryRow getPartition(InternalRow row) {
        this.keyAndBucketExtractor.setRecord(row);
        return this.keyAndBucketExtractor.partition();
    }

    @Override
    public int getBucket(InternalRow row) {
        this.keyAndBucketExtractor.setRecord(row);
        return this.keyAndBucketExtractor.bucket();
    }

    @Override
    public void write(InternalRow row) throws Exception {
        this.writeAndReturn(row);
    }

    @Override
    public void write(InternalRow row, int bucket) throws Exception {
        this.writeAndReturn(row, bucket);
    }

    @Override
    public void writeBundle(BinaryRow partition, int bucket, BundleRecords bundle) throws Exception {
        if (this.write instanceof BundleFileStoreWriter) {
            ((BundleFileStoreWriter)this.write).writeBundle(partition, bucket, bundle);
        } else {
            for (InternalRow row : bundle) {
                this.write(row, bucket);
            }
        }
    }

    @Nullable
    public SinkRecord writeAndReturn(InternalRow row) throws Exception {
        return this.writeAndReturn(row, -1);
    }

    @Nullable
    public SinkRecord writeAndReturn(InternalRow row, int bucket) throws Exception {
        this.checkNullability(row);
        row = this.wrapDefaultValue(row);
        RowKind rowKind = RowKindGenerator.getRowKind(this.rowKindGenerator, row);
        if (this.rowKindFilter != null && !this.rowKindFilter.test(rowKind)) {
            return null;
        }
        SinkRecord record = bucket == -1 ? this.toSinkRecord(row) : this.toSinkRecord(row, bucket);
        this.write.write(record.partition(), record.bucket(), this.recordExtractor.extract(record, rowKind));
        return record;
    }

    private void checkNullability(InternalRow row) {
        for (int idx : this.notNullFieldIndex) {
            if (!row.isNullAt(idx)) continue;
            String columnName = this.writeType.getFields().get(idx).name();
            throw new RuntimeException(String.format("Cannot write null to non-null column(%s)", columnName));
        }
    }

    private InternalRow wrapDefaultValue(InternalRow row) {
        return this.defaultValueRow == null ? row : this.defaultValueRow.replaceRow(row);
    }

    private SinkRecord toSinkRecord(InternalRow row) {
        this.keyAndBucketExtractor.setRecord(row);
        return new SinkRecord(this.keyAndBucketExtractor.partition(), this.keyAndBucketExtractor.bucket(), this.keyAndBucketExtractor.trimmedPrimaryKey(), row);
    }

    private SinkRecord toSinkRecord(InternalRow row, int bucket) {
        this.keyAndBucketExtractor.setRecord(row);
        return new SinkRecord(this.keyAndBucketExtractor.partition(), bucket, this.keyAndBucketExtractor.trimmedPrimaryKey(), row);
    }

    public SinkRecord toLogRecord(SinkRecord record) {
        this.keyAndBucketExtractor.setRecord(record.row());
        return new SinkRecord(record.partition(), this.bucketMode == BucketMode.BUCKET_UNAWARE ? -1 : record.bucket(), this.keyAndBucketExtractor.logPrimaryKey(), record.row());
    }

    @Override
    public void compact(BinaryRow partition, int bucket, boolean fullCompaction) throws Exception {
        this.write.compact(partition, bucket, fullCompaction);
    }

    @Override
    public TableWriteImpl<T> withMetricRegistry(MetricRegistry metricRegistry) {
        this.write.withMetricRegistry(metricRegistry);
        return this;
    }

    public void notifyNewFiles(long snapshotId, BinaryRow partition, int bucket, List<DataFileMeta> files) {
        this.write.notifyNewFiles(snapshotId, partition, bucket, files);
    }

    @Override
    public List<CommitMessage> prepareCommit(boolean waitCompaction, long commitIdentifier) throws Exception {
        return this.write.prepareCommit(waitCompaction, commitIdentifier);
    }

    @Override
    public List<CommitMessage> prepareCommit() throws Exception {
        Preconditions.checkState(!this.batchCommitted, "BatchTableWrite only support one-time committing.");
        this.batchCommitted = true;
        return this.prepareCommit(true, Long.MAX_VALUE);
    }

    @Override
    public void close() throws Exception {
        this.write.close();
    }

    @Override
    public List<FileStoreWrite.State<T>> checkpoint() {
        return (List)this.write.checkpoint();
    }

    @Override
    public void restore(List<FileStoreWrite.State<T>> state) {
        this.write.restore(state);
    }

    @VisibleForTesting
    public FileStoreWrite<T> getWrite() {
        return this.write;
    }

    public static interface RecordExtractor<T> {
        public T extract(SinkRecord var1, RowKind var2);
    }
}

