/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypeJsonParser;
import org.apache.paimon.utils.JsonSerdeUtil;
import org.apache.paimon.utils.StringUtils;

public class ParameterUtils {
    public static List<Map<String, String>> getPartitions(String ... partitionStrings) {
        ArrayList<Map<String, String>> partitions = new ArrayList<Map<String, String>>();
        for (String partition : partitionStrings) {
            partitions.add(ParameterUtils.parseCommaSeparatedKeyValues(partition));
        }
        return partitions;
    }

    public static Map<String, String> parseCommaSeparatedKeyValues(String keyValues) {
        HashMap<String, String> kvs = new HashMap<String, String>();
        if (!StringUtils.isNullOrWhitespaceOnly(keyValues)) {
            for (String kvString : keyValues.split(",")) {
                ParameterUtils.parseKeyValueString(kvs, kvString);
            }
        }
        return kvs;
    }

    public static void parseKeyValueString(Map<String, String> map, String kvString) {
        String[] kv = kvString.split("=", 2);
        if (kv.length != 2) {
            throw new IllegalArgumentException(String.format("Invalid key-value string '%s'. Please use format 'key=value'", kvString));
        }
        map.put(kv[0].trim(), kv[1].trim());
    }

    public static void parseKeyValueList(Map<String, List<String>> mapList, String kvString) {
        String[] kv = kvString.split("=", 2);
        if (kv.length != 2) {
            throw new IllegalArgumentException(String.format("Invalid key-value string '%s'. Please use format 'key=value'", kvString));
        }
        String[] valueArr = kv[1].trim().split(",");
        ArrayList<String> valueList = new ArrayList<String>();
        for (String value : valueArr) {
            valueList.add(value);
        }
        mapList.put(kv[0].trim(), valueList);
    }

    public static List<DataField> parseDataFieldArray(String data) {
        JsonNode jsonArray;
        ArrayList<DataField> list = new ArrayList<DataField>();
        if (data != null && (jsonArray = JsonSerdeUtil.fromJson(data, JsonNode.class)).isArray()) {
            for (JsonNode objNode : jsonArray) {
                DataField dataField = DataTypeJsonParser.parseDataField(objNode);
                list.add(dataField);
            }
        }
        return list;
    }
}

