/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.view;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="action")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SetViewOption.class, name="setOption"), @JsonSubTypes.Type(value=RemoveViewOption.class, name="removeOption"), @JsonSubTypes.Type(value=UpdateViewComment.class, name="updateComment"), @JsonSubTypes.Type(value=AddDialect.class, name="addDialect"), @JsonSubTypes.Type(value=UpdateDialect.class, name="updateDialect"), @JsonSubTypes.Type(value=DropDialect.class, name="dropDialect")})
@Public
public interface ViewChange
extends Serializable {
    public static ViewChange setOption(String key, String value) {
        return new SetViewOption(key, value);
    }

    public static ViewChange removeOption(String key) {
        return new RemoveViewOption(key);
    }

    public static ViewChange updateComment(String comment) {
        return new UpdateViewComment(comment);
    }

    public static ViewChange addDialect(String dialect, String query) {
        return new AddDialect(dialect, query);
    }

    public static ViewChange updateDialect(String dialect, String query) {
        return new UpdateDialect(dialect, query);
    }

    public static ViewChange dropDialect(String dialect) {
        return new DropDialect(dialect);
    }

    public static class Actions {
        public static final String FIELD_TYPE = "action";
        public static final String ADD_DIALECT_ACTION = "addDialect";
        public static final String UPDATE_DIALECT_ACTION = "updateDialect";
        public static final String DROP_DIALECT_ACTION = "dropDialect";
        public static final String SET_OPTION_ACTION = "setOption";
        public static final String REMOVE_OPTION_ACTION = "removeOption";
        public static final String UPDATE_COMMENT_ACTION = "updateComment";

        private Actions() {
        }
    }

    public static final class DropDialect
    implements ViewChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_DIALECT = "dialect";
        @JsonProperty(value="dialect")
        private final String dialect;

        @JsonCreator
        public DropDialect(@JsonProperty(value="dialect") String dialect) {
            this.dialect = dialect;
        }

        @JsonGetter(value="dialect")
        public String dialect() {
            return this.dialect;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DropDialect that = (DropDialect)object;
            return Objects.equals(this.dialect, that.dialect);
        }

        public int hashCode() {
            return Objects.hash(this.dialect);
        }
    }

    public static final class UpdateDialect
    implements ViewChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_DIALECT = "dialect";
        private static final String FIELD_QUERY = "query";
        @JsonProperty(value="dialect")
        private final String dialect;
        @JsonProperty(value="query")
        private final String query;

        @JsonCreator
        public UpdateDialect(@JsonProperty(value="dialect") String dialect, @JsonProperty(value="query") String query) {
            this.dialect = dialect;
            this.query = query;
        }

        @JsonGetter(value="dialect")
        public String dialect() {
            return this.dialect;
        }

        @JsonGetter(value="query")
        public String query() {
            return this.query;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            UpdateDialect that = (UpdateDialect)object;
            return Objects.equals(this.dialect, that.dialect) && Objects.equals(this.query, that.query);
        }

        public int hashCode() {
            return Objects.hash(this.dialect, this.query);
        }
    }

    public static final class AddDialect
    implements ViewChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_DIALECT = "dialect";
        private static final String FIELD_QUERY = "query";
        @JsonProperty(value="dialect")
        private final String dialect;
        @JsonProperty(value="query")
        private final String query;

        @JsonCreator
        public AddDialect(@JsonProperty(value="dialect") String dialect, @JsonProperty(value="query") String query) {
            this.dialect = dialect;
            this.query = query;
        }

        @JsonGetter(value="dialect")
        public String dialect() {
            return this.dialect;
        }

        @JsonGetter(value="query")
        public String query() {
            return this.query;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AddDialect that = (AddDialect)object;
            return Objects.equals(this.dialect, that.dialect) && Objects.equals(this.query, that.query);
        }

        public int hashCode() {
            return Objects.hash(this.dialect, this.query);
        }
    }

    public static final class UpdateViewComment
    implements ViewChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_COMMENT = "comment";
        @JsonProperty(value="comment")
        @Nullable
        private final String comment;

        private UpdateViewComment(@JsonProperty(value="comment") @Nullable String comment) {
            this.comment = comment;
        }

        @JsonGetter(value="comment")
        @Nullable
        public String comment() {
            return this.comment;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            UpdateViewComment that = (UpdateViewComment)object;
            return Objects.equals(this.comment, that.comment);
        }

        public int hashCode() {
            return Objects.hash(this.comment);
        }
    }

    public static final class RemoveViewOption
    implements ViewChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_KEY = "key";
        @JsonProperty(value="key")
        private final String key;

        private RemoveViewOption(@JsonProperty(value="key") String key) {
            this.key = key;
        }

        @JsonGetter(value="key")
        public String key() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveViewOption that = (RemoveViewOption)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }

    public static final class SetViewOption
    implements ViewChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_KEY = "key";
        private static final String FIELD_VALUE = "value";
        @JsonProperty(value="key")
        private final String key;
        @JsonProperty(value="value")
        private final String value;

        @JsonCreator
        private SetViewOption(@JsonProperty(value="key") String key, @JsonProperty(value="value") String value) {
            this.key = key;
            this.value = value;
        }

        @JsonGetter(value="key")
        public String key() {
            return this.key;
        }

        @JsonGetter(value="value")
        public String value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetViewOption that = (SetViewOption)o;
            return this.key.equals(that.key) && this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }
    }
}

