/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.util.HashMap;
import java.util.Optional;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.conf.ReconfigurationUtil;
import org.apache.hadoop.hdfs.protocol.proto.ReconfigurationProtocolProtos;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;

public final class ReconfigurationProtocolUtils {
    private ReconfigurationProtocolUtils() {
    }

    public static ReconfigurationTaskStatus getReconfigurationStatus(ReconfigurationProtocolProtos.GetReconfigurationStatusResponseProto response) {
        HashMap<ReconfigurationUtil.PropertyChange, Optional<String>> statusMap = null;
        long endTime = 0L;
        long startTime = response.getStartTime();
        if (response.hasEndTime()) {
            endTime = response.getEndTime();
        }
        if (response.getChangesCount() > 0) {
            statusMap = Maps.newHashMap();
            for (ReconfigurationProtocolProtos.GetReconfigurationStatusConfigChangeProto change : response.getChangesList()) {
                ReconfigurationUtil.PropertyChange pc = new ReconfigurationUtil.PropertyChange(change.getName(), change.getNewValue(), change.getOldValue());
                String errorMessage = null;
                if (change.hasErrorMessage()) {
                    errorMessage = change.getErrorMessage();
                }
                statusMap.put(pc, Optional.ofNullable(errorMessage));
            }
        }
        return new ReconfigurationTaskStatus(startTime, endTime, statusMap);
    }
}

