/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.source;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.fluss.lake.paimon.source.FlussRowAsPaimonRow;
import org.apache.fluss.lake.paimon.source.PaimonRecordReader;
import org.apache.fluss.lake.paimon.source.PaimonSplit;
import org.apache.fluss.lake.source.SortedRecordReader;
import org.apache.fluss.row.InternalRow;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.PrimaryKeyTableUtils;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.KeyComparatorSupplier;

public class PaimonSortedRecordReader
extends PaimonRecordReader
implements SortedRecordReader {
    Comparator<InternalRow> comparator;

    public PaimonSortedRecordReader(FileStoreTable fileStoreTable, @Nullable PaimonSplit split, @Nullable int[][] project, @Nullable Predicate predicate) throws IOException {
        super(fileStoreTable, split, project, predicate);
        RowType pkKeyType = new RowType(PrimaryKeyTableUtils.addKeyNamePrefix((List)fileStoreTable.schema().primaryKeysFields()));
        this.comparator = this.toFlussRowComparator(this.paimonRowType, (Comparator<org.apache.paimon.data.InternalRow>)new KeyComparatorSupplier(pkKeyType).get());
    }

    public Comparator<InternalRow> order() {
        return this.comparator;
    }

    private Comparator<InternalRow> toFlussRowComparator(RowType rowType, Comparator<org.apache.paimon.data.InternalRow> paimonRowcomparator) {
        return (row1, row2) -> paimonRowcomparator.compare(new FlussRowAsPaimonRow((InternalRow)row1, rowType), new FlussRowAsPaimonRow((InternalRow)row2, rowType));
    }
}

