/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.fluss.client.Connection;
import org.apache.fluss.client.ConnectionFactory;
import org.apache.fluss.client.admin.Admin;
import org.apache.fluss.client.metadata.LakeSnapshot;
import org.apache.fluss.config.Configuration;
import org.apache.fluss.exception.LakeTableSnapshotNotExistException;
import org.apache.fluss.lake.committer.LakeCommitResult;
import org.apache.fluss.lake.paimon.utils.PaimonDvTableUtils;
import org.apache.fluss.lake.paimon.utils.PaimonPartitionBucket;
import org.apache.fluss.metadata.PartitionInfo;
import org.apache.fluss.metadata.TableBucket;
import org.apache.fluss.metadata.TablePath;
import org.apache.fluss.utils.ExceptionUtils;
import org.apache.fluss.utils.Preconditions;
import org.apache.fluss.utils.types.Tuple2;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DvTableReadableSnapshotRetriever
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DvTableReadableSnapshotRetriever.class);
    private final TablePath tablePath;
    private final long tableId;
    private final FileStoreTable fileStoreTable;
    private final Admin flussAdmin;
    private final Connection flussConnection;
    private final SnapshotManager snapshotManager;

    public DvTableReadableSnapshotRetriever(TablePath tablePath, long tableId, FileStoreTable paimonFileStoreTable, Configuration flussConfig) {
        this.tablePath = tablePath;
        this.tableId = tableId;
        this.fileStoreTable = paimonFileStoreTable;
        this.flussConnection = ConnectionFactory.createConnection((Configuration)flussConfig);
        this.flussAdmin = this.flussConnection.getAdmin();
        this.snapshotManager = this.fileStoreTable.snapshotManager();
    }

    @Nullable
    public ReadableSnapshotResult getReadableSnapshotAndOffsets(long tieredSnapshotId) throws IOException {
        Snapshot compactedSnapshotPreviousAppendSnapshot;
        LakeSnapshot lastCompactedLakeSnapshot;
        Snapshot latestCompactedSnapshot;
        block20: {
            latestCompactedSnapshot = this.findPreviousSnapshot(tieredSnapshotId, Snapshot.CommitKind.COMPACT);
            if (latestCompactedSnapshot == null) {
                LOG.info("Can't find latest compacted snapshot before snapshot {}, skip get readable snapshot.", (Object)tieredSnapshotId);
                return null;
            }
            lastCompactedLakeSnapshot = null;
            try {
                lastCompactedLakeSnapshot = (LakeSnapshot)this.flussAdmin.getLakeSnapshot(this.tablePath, latestCompactedSnapshot.id()).get();
            }
            catch (Exception e) {
                Throwable cause = ExceptionUtils.stripExecutionException((Throwable)e);
                if (cause instanceof LakeTableSnapshotNotExistException) break block20;
                LOG.warn("Failed to retrieve lake snapshot {} from Fluss. Will attempt to advance readable snapshot as a fallback.", (Object)latestCompactedSnapshot.id(), (Object)cause);
            }
        }
        if (lastCompactedLakeSnapshot != null) {
            Preconditions.checkState((lastCompactedLakeSnapshot.getSnapshotId() == latestCompactedSnapshot.id() ? 1 : 0) != 0, (String)"Snapshot ID mismatch detected! Expected: %s, Actual in Fluss: %s", (Object[])new Object[]{latestCompactedSnapshot.id(), lastCompactedLakeSnapshot.getSnapshotId()});
            return null;
        }
        HashMap<TableBucket, Long> readableOffsets = new HashMap<TableBucket, Long>();
        FlussTableBucketMapper flussTableBucketMapper = new FlussTableBucketMapper();
        Tuple2<Set<PaimonPartitionBucket>, Set<PaimonPartitionBucket>> bucketsWithoutL0AndWithL0 = this.getBucketsWithoutL0AndWithL0(latestCompactedSnapshot);
        Set bucketsWithoutL0 = (Set)bucketsWithoutL0AndWithL0.f0;
        Set bucketsWithL0 = (Set)bucketsWithoutL0AndWithL0.f1;
        long earliestSnapshotIdToKeep = LakeCommitResult.KEEP_ALL_PREVIOUS;
        if (!bucketsWithoutL0.isEmpty()) {
            LakeSnapshot latestTieredSnapshot;
            try {
                latestTieredSnapshot = (LakeSnapshot)this.flussAdmin.getLatestLakeSnapshot(this.tablePath).get();
            }
            catch (Exception e) {
                LOG.warn("Failed to get latest lake snapshot from Fluss server for compacted snapshot {}; skipping readable snapshot update.", (Object)latestCompactedSnapshot.id(), (Object)e);
                return null;
            }
            this.checkTableConsistent(latestTieredSnapshot);
            for (PaimonPartitionBucket bucket : bucketsWithoutL0) {
                TableBucket tableBucket = flussTableBucketMapper.toTableBucket(bucket);
                if (tableBucket == null) continue;
                readableOffsets.put(tableBucket, (Long)latestTieredSnapshot.getTableBucketsOffset().get(tableBucket));
            }
        }
        if ((compactedSnapshotPreviousAppendSnapshot = this.findPreviousSnapshot(latestCompactedSnapshot.id(), Snapshot.CommitKind.APPEND)) == null) {
            LOG.warn("Failed to find a previous APPEND snapshot before compacted snapshot {} for table {}. This prevents retrieving baseline offsets from Fluss.", (Object)latestCompactedSnapshot.id(), (Object)this.tablePath);
            return null;
        }
        if (bucketsWithL0.isEmpty()) {
            earliestSnapshotIdToKeep = compactedSnapshotPreviousAppendSnapshot.id();
        }
        HashSet allBucketsToAdvance = new HashSet(bucketsWithL0);
        HashMap<Long, LakeSnapshot> lakeSnapshotBySnapshotId = new HashMap<Long, LakeSnapshot>();
        long earliestSnapshotId = (Long)Preconditions.checkNotNull((Object)this.snapshotManager.earliestSnapshotId());
        for (long currentSnapshotId = latestCompactedSnapshot.id(); currentSnapshotId >= earliestSnapshotId && !allBucketsToAdvance.isEmpty(); --currentSnapshotId) {
            Snapshot currentSnapshot = this.snapshotManager.tryGetSnapshot(currentSnapshotId);
            if (currentSnapshot == null || currentSnapshot.commitKind() != Snapshot.CommitKind.COMPACT) continue;
            Set<PaimonPartitionBucket> flushedBuckets = this.getBucketsWithFlushedL0(currentSnapshot);
            for (PaimonPartitionBucket partitionBucket : flushedBuckets) {
                long snapshotId;
                LakeSnapshot lakeSnapshot;
                Snapshot previousAppendSnapshot;
                TableBucket tb = flussTableBucketMapper.toTableBucket(partitionBucket);
                if (tb == null) {
                    allBucketsToAdvance.remove(partitionBucket);
                    continue;
                }
                if (readableOffsets.containsKey(tb)) continue;
                Snapshot sourceSnapshot = PaimonDvTableUtils.findLatestSnapshotExactlyHoldingL0Files(this.fileStoreTable, currentSnapshot);
                if (sourceSnapshot == null) {
                    LOG.warn("Cannot find snapshot holding L0 files flushed by compacted snapshot {} for bucket {}, the snapshot may have been expired. Consider increasing snapshot retention.", (Object)currentSnapshot.id(), (Object)tb);
                    return null;
                }
                Snapshot snapshot = previousAppendSnapshot = sourceSnapshot.commitKind() == Snapshot.CommitKind.APPEND ? sourceSnapshot : this.findPreviousSnapshot(sourceSnapshot.id(), Snapshot.CommitKind.APPEND);
                if (previousAppendSnapshot == null) {
                    LOG.warn("Cannot find previous APPEND snapshot before snapshot {} for bucket {}. This may be due to snapshot expiration. Consider increasing paimon snapshot retention.", (Object)sourceSnapshot.id(), (Object)tb);
                    return null;
                }
                if (earliestSnapshotIdToKeep <= 0L || previousAppendSnapshot.id() < earliestSnapshotIdToKeep) {
                    earliestSnapshotIdToKeep = previousAppendSnapshot.id();
                }
                if ((lakeSnapshot = this.getOrFetchLakeSnapshot(snapshotId = previousAppendSnapshot.id(), lakeSnapshotBySnapshotId)) == null) {
                    return null;
                }
                Long offset = (Long)lakeSnapshot.getTableBucketsOffset().get(tb);
                if (offset != null) {
                    readableOffsets.put(tb, offset);
                    allBucketsToAdvance.remove(partitionBucket);
                    continue;
                }
                LOG.error("Could not find offset for bucket {} in snapshot {}, skip advancing readable snapshot.", (Object)tb, (Object)snapshotId);
                return null;
            }
        }
        if (!allBucketsToAdvance.isEmpty()) {
            LOG.warn("Could not find flushed snapshots for buckets with L0: {}. These buckets have L0 files but no found compaction snapshot has flushed them yet. Consider increasing paimon snapshot retention.", allBucketsToAdvance);
            return null;
        }
        LakeSnapshot tieredLakeSnapshot = this.getOrFetchLakeSnapshot(compactedSnapshotPreviousAppendSnapshot.id(), lakeSnapshotBySnapshotId);
        if (tieredLakeSnapshot == null) {
            return null;
        }
        Map tieredOffsets = tieredLakeSnapshot.getTableBucketsOffset();
        return new ReadableSnapshotResult(latestCompactedSnapshot.id(), tieredOffsets, readableOffsets, earliestSnapshotIdToKeep);
    }

    private void checkTableConsistent(LakeSnapshot lakeSnapshot) {
        if (lakeSnapshot.getTableBucketsOffset().isEmpty()) {
            return;
        }
        long snapshotTableId = ((TableBucket)lakeSnapshot.getTableBucketsOffset().keySet().iterator().next()).getTableId();
        if (snapshotTableId != this.tableId) {
            throw new IllegalStateException(String.format("Table id mismatch: Fluss snapshot is for table %s but current tiering table is %s. Table may have been re-created.", snapshotTableId, this.tableId));
        }
    }

    @Nullable
    private LakeSnapshot getOrFetchLakeSnapshot(long snapshotId, Map<Long, LakeSnapshot> cache) {
        LakeSnapshot snapshot = cache.get(snapshotId);
        if (snapshot != null) {
            return snapshot;
        }
        try {
            snapshot = (LakeSnapshot)this.flussAdmin.getLakeSnapshot(this.tablePath, snapshotId).get();
        }
        catch (Exception e) {
            LOG.error("Failed to retrieve lake snapshot {} from Fluss server for table {}; skipping readable snapshot update.", new Object[]{this.tablePath, snapshotId, e});
            return null;
        }
        this.checkTableConsistent(snapshot);
        cache.put(snapshotId, snapshot);
        return snapshot;
    }

    private Tuple2<Set<PaimonPartitionBucket>, Set<PaimonPartitionBucket>> getBucketsWithoutL0AndWithL0(Snapshot snapshot) {
        HashSet<PaimonPartitionBucket> bucketsWithoutL0 = new HashSet<PaimonPartitionBucket>();
        HashSet<PaimonPartitionBucket> bucketsWithL0 = new HashSet<PaimonPartitionBucket>();
        HashMap<String, String> scanOptions = new HashMap<String, String>();
        scanOptions.put(CoreOptions.SCAN_SNAPSHOT_ID.key(), String.valueOf(snapshot.id()));
        scanOptions.put(CoreOptions.BATCH_SCAN_MODE.key(), CoreOptions.BatchScanMode.COMPACT.getValue());
        Map manifestsByBucket = FileStoreScan.Plan.groupByPartFiles((List)this.fileStoreTable.copy(scanOptions).store().newScan().plan().files());
        for (Map.Entry manifestsByBucketEntry : manifestsByBucket.entrySet()) {
            BinaryRow partition = (BinaryRow)manifestsByBucketEntry.getKey();
            Map buckets = (Map)manifestsByBucketEntry.getValue();
            for (Map.Entry bucketEntry : buckets.entrySet()) {
                if (((List)bucketEntry.getValue()).stream().allMatch(manifestEntry -> manifestEntry.kind() != FileKind.DELETE && manifestEntry.file().level() > 0)) {
                    bucketsWithoutL0.add(new PaimonPartitionBucket(partition, (Integer)bucketEntry.getKey()));
                    continue;
                }
                bucketsWithL0.add(new PaimonPartitionBucket(partition, (Integer)bucketEntry.getKey()));
            }
        }
        return Tuple2.of(bucketsWithoutL0, bucketsWithL0);
    }

    private Set<PaimonPartitionBucket> getBucketsWithFlushedL0(Snapshot compactedSnapshot) {
        Preconditions.checkState((compactedSnapshot.commitKind() == Snapshot.CommitKind.COMPACT ? 1 : 0) != 0);
        HashSet<PaimonPartitionBucket> flushedBuckets = new HashSet<PaimonPartitionBucket>();
        List manifestEntries = this.fileStoreTable.store().newScan().withSnapshot(compactedSnapshot.id()).withKind(ScanMode.DELTA).plan().files(FileKind.DELETE);
        for (ManifestEntry manifestEntry : manifestEntries) {
            if (manifestEntry.level() != 0) continue;
            flushedBuckets.add(new PaimonPartitionBucket(manifestEntry.partition(), manifestEntry.bucket()));
        }
        return flushedBuckets;
    }

    @Nullable
    private Snapshot findPreviousSnapshot(long beforeSnapshotId, Snapshot.CommitKind commitKind) throws IOException {
        SnapshotManager snapshotManager = this.fileStoreTable.snapshotManager();
        long earliestSnapshotId = (Long)Preconditions.checkNotNull((Object)snapshotManager.earliestSnapshotId());
        for (long currentSnapshotId = beforeSnapshotId - 1L; currentSnapshotId >= earliestSnapshotId; --currentSnapshotId) {
            Snapshot snapshot = snapshotManager.tryGetSnapshot(currentSnapshotId);
            if (snapshot == null || snapshot.commitKind() != commitKind) continue;
            return snapshot;
        }
        return null;
    }

    private Map<String, Long> getPartitionNameToIdMapping() throws IOException {
        try {
            List partitionInfos = (List)this.flussAdmin.listPartitionInfos(this.tablePath).get();
            return partitionInfos.stream().collect(Collectors.toMap(PartitionInfo::getPartitionName, PartitionInfo::getPartitionId));
        }
        catch (Exception e) {
            throw new IOException("Fail to list partitions", e);
        }
    }

    private String getPartitionNameFromBinaryRow(BinaryRow partition) {
        ArrayList<String> partitionValues = new ArrayList<String>();
        for (int i = 0; i < partition.getFieldCount(); ++i) {
            BinaryString binaryString = partition.getString(i);
            partitionValues.add(binaryString.toString());
        }
        return String.join((CharSequence)"$", partitionValues);
    }

    @Override
    public void close() throws Exception {
        if (this.flussAdmin != null) {
            this.flussAdmin.close();
        }
        if (this.flussConnection != null) {
            this.flussConnection.close();
        }
    }

    private final class FlussTableBucketMapper {
        private final Map<String, Long> partitionNameToIdMapping;

        private FlussTableBucketMapper() throws IOException {
            this.partitionNameToIdMapping = !DvTableReadableSnapshotRetriever.this.fileStoreTable.partitionKeys().isEmpty() ? DvTableReadableSnapshotRetriever.this.getPartitionNameToIdMapping() : null;
        }

        @Nullable
        private TableBucket toTableBucket(PaimonPartitionBucket partitionBucket) {
            if (partitionBucket.getPartition().getFieldCount() == 0) {
                return new TableBucket(DvTableReadableSnapshotRetriever.this.tableId, partitionBucket.getBucket().intValue());
            }
            String partitionName = DvTableReadableSnapshotRetriever.this.getPartitionNameFromBinaryRow(partitionBucket.getPartition());
            Long partitionId = this.partitionNameToIdMapping.get(partitionName);
            if (partitionId == null) {
                LOG.warn("Partition name '{}' not found in Fluss for table {}. Available partitions: {}", new Object[]{partitionName, DvTableReadableSnapshotRetriever.this.tablePath, this.partitionNameToIdMapping.keySet()});
                return null;
            }
            return new TableBucket(DvTableReadableSnapshotRetriever.this.tableId, partitionId, partitionBucket.getBucket().intValue());
        }
    }

    public static class ReadableSnapshotResult {
        private final long readableSnapshotId;
        private final Map<TableBucket, Long> tieredOffsets;
        private final Map<TableBucket, Long> readableOffsets;
        private final long earliestSnapshotIdToKeep;

        public ReadableSnapshotResult(long readableSnapshotId, Map<TableBucket, Long> tieredOffsets, Map<TableBucket, Long> readableOffsets, long earliestSnapshotIdToKeep) {
            this.readableSnapshotId = readableSnapshotId;
            this.tieredOffsets = tieredOffsets;
            this.readableOffsets = readableOffsets;
            this.earliestSnapshotIdToKeep = earliestSnapshotIdToKeep;
        }

        public Map<TableBucket, Long> getTieredOffsets() {
            return this.tieredOffsets;
        }

        public long getReadableSnapshotId() {
            return this.readableSnapshotId;
        }

        public Map<TableBucket, Long> getReadableOffsets() {
            return this.readableOffsets;
        }

        public long getEarliestSnapshotIdToKeep() {
            return this.earliestSnapshotIdToKeep;
        }
    }
}

