/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.fluss.lake.paimon.utils.PaimonPartitionBucket;
import org.apache.fluss.utils.Preconditions;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.utils.SnapshotManager;

public class PaimonDvTableUtils {
    @Nullable
    public static Snapshot findLatestSnapshotExactlyHoldingL0Files(FileStoreTable fileStoreTable, Snapshot compactedSnapshot) throws IOException {
        SnapshotManager snapshotManager = fileStoreTable.snapshotManager();
        Preconditions.checkState((compactedSnapshot.commitKind() == Snapshot.CommitKind.COMPACT ? 1 : 0) != 0);
        Map<PaimonPartitionBucket, Set<String>> deletedL0FilesByBucket = PaimonDvTableUtils.getDeletedL0FilesByBucket(fileStoreTable, compactedSnapshot);
        if (deletedL0FilesByBucket.isEmpty()) {
            return null;
        }
        long earliestSnapshot = (Long)Preconditions.checkNotNull((Object)snapshotManager.earliestSnapshotId());
        for (long snapshot = compactedSnapshot.id() - 1L; snapshot >= earliestSnapshot; --snapshot) {
            Snapshot candidateSnapshot = snapshotManager.tryGetSnapshot(snapshot);
            if (candidateSnapshot == null || !PaimonDvTableUtils.matchesDeletedL0Files(fileStoreTable, candidateSnapshot, deletedL0FilesByBucket)) continue;
            return candidateSnapshot;
        }
        return null;
    }

    private static Map<PaimonPartitionBucket, Set<String>> getDeletedL0FilesByBucket(FileStoreTable fileStoreTable, Snapshot compactedSnapshot) {
        HashMap<PaimonPartitionBucket, Set<String>> deletedL0FilesByBucket = new HashMap<PaimonPartitionBucket, Set<String>>();
        List manifestEntries = fileStoreTable.store().newScan().withSnapshot(compactedSnapshot.id()).withKind(ScanMode.DELTA).plan().files(FileKind.DELETE);
        for (ManifestEntry manifestEntry : manifestEntries) {
            if (manifestEntry.level() != 0) continue;
            deletedL0FilesByBucket.computeIfAbsent(new PaimonPartitionBucket(manifestEntry.partition(), manifestEntry.bucket()), k -> new HashSet()).add(manifestEntry.fileName());
        }
        return deletedL0FilesByBucket;
    }

    private static boolean matchesDeletedL0Files(FileStoreTable fileStoreTable, Snapshot candidateSnapshot, Map<PaimonPartitionBucket, Set<String>> deletedL0FilesByBucket) {
        Map<PaimonPartitionBucket, Set<String>> candidateL0FilesByBucket = PaimonDvTableUtils.getL0FilesByBucket(fileStoreTable, candidateSnapshot);
        for (Map.Entry<PaimonPartitionBucket, Set<String>> deleteL0Entry : deletedL0FilesByBucket.entrySet()) {
            Set<String> deleteL0Files = candidateL0FilesByBucket.get(deleteL0Entry.getKey());
            if (deleteL0Files != null && deleteL0Files.equals(deleteL0Entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private static Map<PaimonPartitionBucket, Set<String>> getL0FilesByBucket(FileStoreTable fileStoreTable, Snapshot snapshot) {
        HashMap<PaimonPartitionBucket, Set<String>> l0FilesByBucket = new HashMap<PaimonPartitionBucket, Set<String>>();
        HashMap<String, String> scanOptions = new HashMap<String, String>();
        scanOptions.put(CoreOptions.SCAN_SNAPSHOT_ID.key(), String.valueOf(snapshot.id()));
        scanOptions.put(CoreOptions.BATCH_SCAN_MODE.key(), CoreOptions.BatchScanMode.COMPACT.getValue());
        List splits = fileStoreTable.copy(scanOptions).newScan().plan().splits();
        for (Split split : splits) {
            DataSplit dataSplit = (DataSplit)split;
            for (DataFileMeta dataFileMeta : dataSplit.dataFiles()) {
                if (dataFileMeta.level() != 0) continue;
                l0FilesByBucket.computeIfAbsent(new PaimonPartitionBucket(dataSplit.partition(), dataSplit.bucket()), k -> new HashSet()).add(dataFileMeta.fileName());
            }
        }
        return l0FilesByBucket;
    }
}

