/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.metrics.prometheus;

import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.fluss.annotation.VisibleForTesting;
import org.apache.fluss.config.ConfigOptions;
import org.apache.fluss.config.Configuration;
import org.apache.fluss.metrics.prometheus.PrometheusPushGatewayReporter;
import org.apache.fluss.metrics.reporter.MetricReporter;
import org.apache.fluss.metrics.reporter.MetricReporterPlugin;
import org.apache.fluss.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusPushGatewayReporterPlugin
implements MetricReporterPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusPushGatewayReporterPlugin.class);
    private static final String PLUGIN_NAME = "prometheus-push";

    public MetricReporter createMetricReporter(Configuration config) {
        String hostUrl = (String)config.get(ConfigOptions.METRICS_REPORTER_PROMETHEUS_PUSHGATEWAY_HOST_URL);
        String configuredJobName = (String)config.get(ConfigOptions.METRICS_REPORTER_PROMETHEUS_PUSHGATEWAY_JOB_NAME);
        boolean deleteOnShutdown = (Boolean)config.get(ConfigOptions.METRICS_REPORTER_PROMETHEUS_PUSHGATEWAY_DELETE_ON_SHUTDOWN);
        boolean randomSuffix = (Boolean)config.get(ConfigOptions.METRICS_REPORTER_PROMETHEUS_PUSHGATEWAY_RANDOM_JOB_NAME_SUFFIX);
        Duration pushInterval = (Duration)config.get(ConfigOptions.METRICS_REPORTER_PROMETHEUS_PUSHGATEWAY_PUSH_INTERVAL);
        Object jobName = configuredJobName;
        if (randomSuffix) {
            jobName = configuredJobName + new Random().nextLong();
        }
        Map<String, String> groupingKey = PrometheusPushGatewayReporterPlugin.parseGroupingKey((String)config.get(ConfigOptions.METRICS_REPORTER_PROMETHEUS_PUSHGATEWAY_GROUPING_KEY));
        LOG.info("Configured PrometheusPushGatewayReporter with {hostUrl:{}, jobName:{}, randomJobNameSuffix:{}, deleteOnShutdown:{}, groupingKey:{}, pushInterval:{}}", new Object[]{hostUrl, jobName, randomSuffix, deleteOnShutdown, groupingKey, pushInterval});
        try {
            return new PrometheusPushGatewayReporter(new URL(hostUrl), (String)jobName, groupingKey, deleteOnShutdown, pushInterval);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String identifier() {
        return PLUGIN_NAME;
    }

    @VisibleForTesting
    static Map<String, String> parseGroupingKey(String groupingKeyConfig) {
        if (!groupingKeyConfig.isEmpty()) {
            String[] kvs;
            HashMap<String, String> groupingKey = new HashMap<String, String>();
            for (String kv : kvs = groupingKeyConfig.split(";")) {
                int idx = kv.indexOf("=");
                if (idx < 0) {
                    LOG.warn("Invalid prometheusPushGateway groupingKey:{}, will be ignored", (Object)kv);
                    continue;
                }
                String labelKey = kv.substring(0, idx);
                String labelValue = kv.substring(idx + 1);
                if (StringUtils.isNullOrWhitespaceOnly((String)labelKey) || StringUtils.isNullOrWhitespaceOnly((String)labelValue)) {
                    LOG.warn("Invalid groupingKey {labelKey:{}, labelValue:{}} must not be empty", (Object)labelKey, (Object)labelValue);
                    continue;
                }
                groupingKey.put(labelKey, labelValue);
            }
            return groupingKey;
        }
        return Collections.emptyMap();
    }
}

