/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.serializer;

public enum SerializerType {
    SEATA(1),
    PROTOBUF(2),
    KRYO(4),
    FST(8),
    HESSIAN(22),
    JACKSON(50),
    FASTJSON2(100),
    GRPC(40),
    FURY(86),
    FORY(87);

    private final byte code;

    private SerializerType(byte code) {
        this.code = code;
    }

    public static SerializerType getByCode(int code) {
        for (SerializerType b : SerializerType.values()) {
            if (code != b.code) continue;
            return b;
        }
        if (code == FST.getCode()) {
            throw new IllegalArgumentException("Since fst is no longer maintained, this serialization extension has been removed from version 2.0 for security and stability reasons.");
        }
        throw new IllegalArgumentException("unknown codec:" + code);
    }

    public static SerializerType getByName(String name) {
        for (SerializerType b : SerializerType.values()) {
            if (!b.name().equalsIgnoreCase(name)) continue;
            return b;
        }
        throw new IllegalArgumentException("unknown codec:" + name);
    }

    public byte getCode() {
        return this.code;
    }
}

