/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.remoting;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.rpc.RpcClient;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.sofa.registry.client.api.Configurator;
import com.alipay.sofa.registry.client.api.Publisher;
import com.alipay.sofa.registry.client.api.RegistryClientConfig;
import com.alipay.sofa.registry.client.api.Subscriber;
import com.alipay.sofa.registry.client.log.LoggerFactory;
import com.alipay.sofa.registry.client.provider.RegisterCache;
import com.alipay.sofa.registry.client.remoting.Client;
import com.alipay.sofa.registry.client.remoting.ServerManager;
import com.alipay.sofa.registry.client.remoting.ServerNode;
import com.alipay.sofa.registry.client.task.TaskEvent;
import com.alipay.sofa.registry.client.task.Worker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;

public class ClientConnection
implements Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientConnection.class);
    private static final int RECONNECTING_DELAY = 5000;
    private RpcClient client = new RpcClient();
    private ServerManager serverManager;
    private List<UserProcessor> userProcessorList;
    private Map<ConnectionEventType, ConnectionEventProcessor> connectionEventProcessorMap;
    private RegistryClientConfig config;
    private Connection clientConnection;
    private RegisterCache registerCache;
    private Worker worker;

    public ClientConnection(ServerManager serverManager, List<UserProcessor> userProcessorList, Map<ConnectionEventType, ConnectionEventProcessor> connectionEventProcessorMap, RegisterCache registerCache, RegistryClientConfig config) {
        this.serverManager = serverManager;
        this.userProcessorList = userProcessorList;
        this.connectionEventProcessorMap = connectionEventProcessorMap;
        this.registerCache = registerCache;
        this.config = config;
    }

    @Override
    public void init() {
        for (UserProcessor userProcessor : this.userProcessorList) {
            this.client.registerUserProcessor(userProcessor);
        }
        if (null != this.connectionEventProcessorMap) {
            for (Map.Entry entry : this.connectionEventProcessorMap.entrySet()) {
                this.client.addConnectionEventProcessor((ConnectionEventType)entry.getKey(), (ConnectionEventProcessor)entry.getValue());
            }
        }
        this.client.init();
    }

    @Override
    public void ensureConnected() throws InterruptedException {
        if (this.isConnected()) {
            return;
        }
        while (!this.connect()) {
            Thread.sleep(5000L);
        }
    }

    private boolean connect() {
        Random random = new Random();
        Connection connection = null;
        ArrayList<ServerNode> serverNodes = new ArrayList<ServerNode>(this.serverManager.getServerList());
        Collections.shuffle(serverNodes);
        for (ServerNode serverNode : serverNodes) {
            try {
                connection = this.connect(serverNode);
                if (null != connection && connection.isFine()) {
                    this.resetRegister();
                    LOGGER.info("[Connect] Successfully connected to server: {}", (Object)serverNode);
                    break;
                }
                this.recycle(connection);
                Thread.sleep(random.nextInt(5000));
            }
            catch (Exception e) {
                LOGGER.error("[Connect] Failed trying connect to {}", (Object)serverNode, (Object)e);
            }
        }
        if (null != connection && connection.isFine()) {
            this.clientConnection = connection;
            return true;
        }
        return false;
    }

    @Override
    public Object invokeSync(Object request) throws RemotingException, InterruptedException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
        return this.client.invokeSync(this.clientConnection, request, this.config.getInvokeTimeout());
    }

    private void recycle(Connection connection) {
        if (null == connection) {
            return;
        }
        this.client.closeConnection(connection.getUrl());
    }

    private Connection connect(ServerNode serverNode) {
        Connection connection = null;
        try {
            connection = this.client.getConnection(serverNode.getUrl(), this.config.getConnectTimeout());
        }
        catch (Exception e) {
            LOGGER.error("[connection] Create connection error, {}", (Object)serverNode, (Object)e);
        }
        return connection;
    }

    private void resetRegister() {
        try {
            ArrayList<TaskEvent> eventList = new ArrayList<TaskEvent>();
            Collection<Publisher> publishers = this.registerCache.getAllPublishers();
            for (Publisher publisher : publishers) {
                try {
                    publisher.reset();
                    eventList.add(new TaskEvent(publisher));
                }
                catch (Exception e) {
                    LOGGER.error("[connection] Publisher reset error, {}", (Object)publisher, (Object)e);
                }
            }
            Collection<Subscriber> subscribers = this.registerCache.getAllSubscribers();
            for (Subscriber subscriber : subscribers) {
                try {
                    subscriber.reset();
                    eventList.add(new TaskEvent(subscriber));
                }
                catch (Exception e) {
                    LOGGER.error("[connection] Subscriber reset error, {}", (Object)subscriber, (Object)e);
                }
            }
            Collection<Configurator> collection = this.registerCache.getAllConfigurator();
            for (Configurator configurator : collection) {
                try {
                    configurator.reset();
                    eventList.add(new TaskEvent(configurator));
                }
                catch (Exception e) {
                    LOGGER.error("[connection] Configurator reset error, {}", (Object)configurator, (Object)e);
                }
            }
            this.worker.schedule(eventList);
            LOGGER.info("[reset] {} publishers and {} subscribers has been reset", (Object)publishers.size(), (Object)subscribers.size());
        }
        catch (Exception e) {
            LOGGER.error("[reset] Reset register after reconnect error", (Throwable)e);
        }
    }

    public String getRemoteAddress() {
        if (null != this.clientConnection) {
            return this.clientConnection.getRemoteIP();
        }
        return null;
    }

    @Override
    public boolean isConnected() {
        return this.clientConnection != null && this.clientConnection.isFine();
    }

    public void destroy() {
        if (null != this.clientConnection) {
            this.clientConnection.close();
        }
        if (null != this.client) {
            this.client.shutdown();
        }
    }

    public void setServerManager(ServerManager serverManager) {
        this.serverManager = serverManager;
    }

    public void setUserProcessorList(List<UserProcessor> userProcessorList) {
        this.userProcessorList = userProcessorList;
    }

    public void setConnectionEventProcessorMap(Map<ConnectionEventType, ConnectionEventProcessor> connectionEventProcessorMap) {
        this.connectionEventProcessorMap = connectionEventProcessorMap;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
    }
}

