/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.kryo;

import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.core.protocol.AbstractMessage;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.serializer.kryo.KryoInnerSerializer;
import org.apache.seata.serializer.kryo.KryoSerializerFactory;

@LoadLevel(name="KRYO")
public class KryoSerializer
implements Serializer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> byte[] serialize(T t) {
        if (!(t instanceof AbstractMessage)) {
            throw new IllegalArgumentException("message is illegal");
        }
        KryoInnerSerializer kryoSerializer = KryoSerializerFactory.getInstance().get();
        try {
            byte[] byArray = kryoSerializer.serialize(t);
            return byArray;
        }
        finally {
            KryoSerializerFactory.getInstance().returnKryo(kryoSerializer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("bytes is null");
        }
        KryoInnerSerializer kryoSerializer = KryoSerializerFactory.getInstance().get();
        try {
            Object t = kryoSerializer.deserialize(bytes);
            return t;
        }
        finally {
            KryoSerializerFactory.getInstance().returnKryo(kryoSerializer);
        }
    }
}

