/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpRange;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.ResourceRegionHttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.PathExtensionContentNegotiationStrategy;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.resource.DefaultResourceResolverChain;
import org.springframework.web.servlet.resource.DefaultResourceTransformerChain;
import org.springframework.web.servlet.resource.HttpResource;
import org.springframework.web.servlet.resource.NoResourceFoundException;
import org.springframework.web.servlet.resource.PathResourceResolver;
import org.springframework.web.servlet.resource.ResourceHandlerUtils;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.support.WebContentGenerator;
import org.springframework.web.util.UrlPathHelper;

public class ResourceHttpRequestHandler
extends WebContentGenerator
implements HttpRequestHandler,
EmbeddedValueResolverAware,
InitializingBean,
CorsConfigurationSource {
    private static final Log logger = LogFactory.getLog(ResourceHttpRequestHandler.class);
    private static final String URL_RESOURCE_CHARSET_PREFIX = "[charset=";
    private final List<String> locationValues = new ArrayList<String>(4);
    private final List<Resource> locationResources = new ArrayList<Resource>(4);
    private final List<Resource> locationsToUse = new ArrayList<Resource>(4);
    private final Map<Resource, Charset> locationCharsets = new HashMap<Resource, Charset>(4);
    private final List<ResourceResolver> resourceResolvers = new ArrayList<ResourceResolver>(4);
    private final List<ResourceTransformer> resourceTransformers = new ArrayList<ResourceTransformer>(4);
    @Nullable
    private ResourceResolverChain resolverChain;
    @Nullable
    private ResourceTransformerChain transformerChain;
    @Nullable
    private ResourceHttpMessageConverter resourceHttpMessageConverter;
    @Nullable
    private ResourceRegionHttpMessageConverter resourceRegionHttpMessageConverter;
    @Nullable
    private ContentNegotiationManager contentNegotiationManager;
    private final Map<String, MediaType> mediaTypes = new HashMap<String, MediaType>(4);
    @Nullable
    private CorsConfiguration corsConfiguration;
    @Nullable
    private UrlPathHelper urlPathHelper;
    private boolean useLastModified = true;
    @Nullable
    private Function<Resource, String> etagGenerator;
    private boolean optimizeLocations = false;
    @Nullable
    private StringValueResolver embeddedValueResolver;

    public ResourceHttpRequestHandler() {
        super(HttpMethod.GET.name(), HttpMethod.HEAD.name());
    }

    public void setLocationValues(List<String> locations) {
        Assert.notNull(locations, (String)"Locations list must not be null");
        this.locationValues.clear();
        this.locationValues.addAll(locations);
    }

    public void setLocations(List<Resource> locations) {
        Assert.notNull(locations, (String)"Locations list must not be null");
        this.locationResources.clear();
        for (Resource location : locations) {
            ResourceHandlerUtils.assertResourceLocation(location);
            this.locationResources.add(location);
        }
    }

    public List<Resource> getLocations() {
        if (this.locationsToUse.isEmpty()) {
            return this.locationResources;
        }
        return this.locationsToUse;
    }

    public void setResourceResolvers(@Nullable List<ResourceResolver> resourceResolvers) {
        this.resourceResolvers.clear();
        if (resourceResolvers != null) {
            this.resourceResolvers.addAll(resourceResolvers);
        }
    }

    public List<ResourceResolver> getResourceResolvers() {
        return this.resourceResolvers;
    }

    public void setResourceTransformers(@Nullable List<ResourceTransformer> resourceTransformers) {
        this.resourceTransformers.clear();
        if (resourceTransformers != null) {
            this.resourceTransformers.addAll(resourceTransformers);
        }
    }

    public List<ResourceTransformer> getResourceTransformers() {
        return this.resourceTransformers;
    }

    public void setResourceHttpMessageConverter(@Nullable ResourceHttpMessageConverter messageConverter) {
        this.resourceHttpMessageConverter = messageConverter;
    }

    @Nullable
    public ResourceHttpMessageConverter getResourceHttpMessageConverter() {
        return this.resourceHttpMessageConverter;
    }

    public void setResourceRegionHttpMessageConverter(@Nullable ResourceRegionHttpMessageConverter messageConverter) {
        this.resourceRegionHttpMessageConverter = messageConverter;
    }

    @Nullable
    public ResourceRegionHttpMessageConverter getResourceRegionHttpMessageConverter() {
        return this.resourceRegionHttpMessageConverter;
    }

    @Deprecated
    public void setContentNegotiationManager(@Nullable ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    @Nullable
    @Deprecated
    public ContentNegotiationManager getContentNegotiationManager() {
        return this.contentNegotiationManager;
    }

    public void setMediaTypes(Map<String, MediaType> mediaTypes) {
        mediaTypes.forEach((ext, mediaType) -> this.mediaTypes.put(ext.toLowerCase(Locale.ROOT), (MediaType)mediaType));
    }

    public Map<String, MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    public void setCorsConfiguration(CorsConfiguration corsConfiguration) {
        this.corsConfiguration = corsConfiguration;
    }

    @Nullable
    public CorsConfiguration getCorsConfiguration(HttpServletRequest request) {
        return this.corsConfiguration;
    }

    public void setUrlPathHelper(@Nullable UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    @Nullable
    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    public void setUseLastModified(boolean useLastModified) {
        this.useLastModified = useLastModified;
    }

    public boolean isUseLastModified() {
        return this.useLastModified;
    }

    public void setEtagGenerator(@Nullable Function<Resource, String> etagGenerator) {
        this.etagGenerator = etagGenerator;
    }

    @Nullable
    public Function<Resource, String> getEtagGenerator() {
        return this.etagGenerator;
    }

    public void setOptimizeLocations(boolean optimizeLocations) {
        this.optimizeLocations = optimizeLocations;
    }

    public boolean isOptimizeLocations() {
        return this.optimizeLocations;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void afterPropertiesSet() throws Exception {
        PathExtensionContentNegotiationStrategy strategy;
        ContentNegotiationManager manager;
        this.resolveResourceLocations();
        if (this.resourceResolvers.isEmpty()) {
            this.resourceResolvers.add(new PathResourceResolver());
        }
        this.initAllowedLocations();
        this.resolverChain = new DefaultResourceResolverChain(this.resourceResolvers);
        this.transformerChain = new DefaultResourceTransformerChain(this.resolverChain, this.resourceTransformers);
        if (this.resourceHttpMessageConverter == null) {
            this.resourceHttpMessageConverter = new ResourceHttpMessageConverter();
        }
        if (this.resourceRegionHttpMessageConverter == null) {
            this.resourceRegionHttpMessageConverter = new ResourceRegionHttpMessageConverter();
        }
        if ((manager = this.getContentNegotiationManager()) != null) {
            this.setMediaTypes(manager.getMediaTypeMappings());
        }
        if ((strategy = this.initContentNegotiationStrategy()) != null) {
            this.setMediaTypes(strategy.getMediaTypes());
        }
    }

    private void resolveResourceLocations() {
        List<Object> result = new ArrayList<Resource>();
        if (!this.locationValues.isEmpty()) {
            ApplicationContext applicationContext = this.obtainApplicationContext();
            for (String location : this.locationValues) {
                if (this.embeddedValueResolver != null) {
                    String resolvedLocation = this.embeddedValueResolver.resolveStringValue(location);
                    if (resolvedLocation == null) {
                        throw new IllegalArgumentException("Location resolved to null: " + location);
                    }
                    location = resolvedLocation;
                }
                Charset charset = null;
                if ((location = location.trim()).startsWith(URL_RESOURCE_CHARSET_PREFIX)) {
                    int endIndex = location.indexOf(93, URL_RESOURCE_CHARSET_PREFIX.length());
                    if (endIndex == -1) {
                        throw new IllegalArgumentException("Invalid charset syntax in location: " + location);
                    }
                    String value = location.substring(URL_RESOURCE_CHARSET_PREFIX.length(), endIndex);
                    charset = Charset.forName(value);
                    location = location.substring(endIndex + 1);
                }
                location = ResourceHandlerUtils.initLocationPath(location);
                Resource resource = applicationContext.getResource(location);
                if (location.equals("/") && !(resource instanceof ServletContextResource)) {
                    throw new IllegalStateException("The String-based location \"/\" should be relative to the web application root but resolved to a Resource of type: " + String.valueOf(resource.getClass()) + ". If this is intentional, please pass it as a pre-configured Resource via setLocations.");
                }
                result.add(resource);
                if (charset == null) continue;
                if (!(resource instanceof UrlResource)) {
                    throw new IllegalArgumentException("Unexpected charset for non-UrlResource: " + String.valueOf(resource));
                }
                this.locationCharsets.put(resource, charset);
            }
        }
        result.addAll(this.locationResources);
        if (this.isOptimizeLocations()) {
            result = result.stream().filter(Resource::exists).toList();
        }
        this.locationsToUse.clear();
        this.locationsToUse.addAll(result);
    }

    protected void initAllowedLocations() {
        if (CollectionUtils.isEmpty(this.getLocations())) {
            return;
        }
        for (int i2 = this.getResourceResolvers().size() - 1; i2 >= 0; --i2) {
            ResourceResolver resourceResolver = this.getResourceResolvers().get(i2);
            if (!(resourceResolver instanceof PathResourceResolver)) continue;
            PathResourceResolver pathResolver = (PathResourceResolver)resourceResolver;
            if (ObjectUtils.isEmpty((Object[])pathResolver.getAllowedLocations())) {
                pathResolver.setAllowedLocations(this.getLocations().toArray(new Resource[0]));
            }
            if (this.urlPathHelper == null) break;
            pathResolver.setLocationCharsets(this.locationCharsets);
            pathResolver.setUrlPathHelper(this.urlPathHelper);
            break;
        }
    }

    @Nullable
    @Deprecated
    protected PathExtensionContentNegotiationStrategy initContentNegotiationStrategy() {
        return null;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long lastModified;
        Resource resource = this.getResource(request);
        if (resource == null) {
            logger.debug((Object)"Resource not found");
            throw new NoResourceFoundException(HttpMethod.valueOf((String)request.getMethod()), ResourceHttpRequestHandler.getPath(request));
        }
        if (HttpMethod.OPTIONS.matches(request.getMethod())) {
            response.setHeader("Allow", this.getAllowHeader());
            return;
        }
        this.checkRequest(request);
        this.prepareResponse(response);
        String eTagValue = this.getEtagGenerator() != null ? this.getEtagGenerator().apply(resource) : null;
        long l = lastModified = this.isUseLastModified() ? resource.lastModified() : -1L;
        if (new ServletWebRequest(request, response).checkNotModified(eTagValue, lastModified)) {
            logger.trace((Object)"Resource not modified");
            return;
        }
        MediaType mediaType = this.getMediaType(request, resource);
        this.setHeaders(response, resource, mediaType);
        ServletServerHttpResponse outputMessage = new ServletServerHttpResponse(response);
        if (request.getHeader("Range") == null) {
            Assert.state((this.resourceHttpMessageConverter != null ? 1 : 0) != 0, (String)"Not initialized");
            if (HttpMethod.HEAD.matches(request.getMethod())) {
                this.resourceHttpMessageConverter.addDefaultHeaders((HttpOutputMessage)outputMessage, resource, mediaType);
                outputMessage.flush();
            } else {
                this.resourceHttpMessageConverter.write((Object)resource, mediaType, (HttpOutputMessage)outputMessage);
            }
        } else {
            Assert.state((this.resourceRegionHttpMessageConverter != null ? 1 : 0) != 0, (String)"Not initialized");
            ServletServerHttpRequest inputMessage = new ServletServerHttpRequest(request);
            try {
                List httpRanges = inputMessage.getHeaders().getRange();
                response.setStatus(206);
                this.resourceRegionHttpMessageConverter.write((Object)HttpRange.toResourceRegions((List)httpRanges, (Resource)resource), mediaType, (HttpOutputMessage)outputMessage);
            }
            catch (IllegalArgumentException ex) {
                response.setHeader("Content-Range", "bytes */" + resource.contentLength());
                response.sendError(416);
            }
        }
    }

    @Nullable
    protected Resource getResource(HttpServletRequest request) throws IOException {
        String path = ResourceHttpRequestHandler.getPath(request);
        if (ResourceHandlerUtils.shouldIgnoreInputPath(path = this.processPath(path)) || this.isInvalidPath(path)) {
            return null;
        }
        Assert.state((this.resolverChain != null ? 1 : 0) != 0, (String)"ResourceResolverChain not initialized.");
        Assert.state((this.transformerChain != null ? 1 : 0) != 0, (String)"ResourceTransformerChain not initialized.");
        Resource resource = this.resolverChain.resolveResource(request, path, this.getLocations());
        if (resource != null) {
            resource = this.transformerChain.transform(request, resource);
        }
        return resource;
    }

    private static String getPath(HttpServletRequest request) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (path == null) {
            throw new IllegalStateException("Required request attribute '" + HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE + "' is not set");
        }
        return path;
    }

    protected String processPath(String path) {
        return ResourceHandlerUtils.normalizeInputPath(path);
    }

    protected boolean isInvalidPath(String path) {
        return false;
    }

    @Nullable
    protected MediaType getMediaType(HttpServletRequest request, Resource resource) {
        MediaType result = null;
        String mimeType = request.getServletContext().getMimeType(resource.getFilename());
        if (StringUtils.hasText((String)mimeType)) {
            result = MediaType.parseMediaType((String)mimeType);
        }
        if (result == null || MediaType.APPLICATION_OCTET_STREAM.equals((Object)result)) {
            List mediaTypes;
            MediaType mediaType = null;
            String filename = resource.getFilename();
            String ext = StringUtils.getFilenameExtension((String)filename);
            if (ext != null) {
                mediaType = this.mediaTypes.get(ext.toLowerCase(Locale.ROOT));
            }
            if (mediaType == null && !CollectionUtils.isEmpty((Collection)(mediaTypes = MediaTypeFactory.getMediaTypes((String)filename)))) {
                mediaType = (MediaType)mediaTypes.get(0);
            }
            if (mediaType != null) {
                result = mediaType;
            }
        }
        return result;
    }

    protected void setHeaders(HttpServletResponse response, Resource resource, @Nullable MediaType mediaType) throws IOException {
        if (mediaType != null) {
            response.setContentType(mediaType.toString());
        }
        if (resource instanceof HttpResource) {
            HttpResource httpResource = (HttpResource)resource;
            HttpHeaders resourceHeaders = httpResource.getResponseHeaders();
            resourceHeaders.forEach((headerName, headerValues) -> {
                boolean first = true;
                for (String headerValue : headerValues) {
                    if (first) {
                        response.setHeader(headerName, headerValue);
                    } else {
                        response.addHeader(headerName, headerValue);
                    }
                    first = false;
                }
            });
        }
        response.setHeader("Accept-Ranges", "bytes");
    }

    public String toString() {
        return "ResourceHttpRequestHandler " + this.locationToString(this.getLocations());
    }

    private String locationToString(List<Resource> locations) {
        return locations.toString().replaceAll("class path resource", "classpath").replaceAll("ServletContext resource", "ServletContext");
    }
}

