/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.seata.common.DefaultValues;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.exception.HttpRequestFilterException;
import org.apache.seata.core.rpc.netty.http.filter.HttpFilterContext;
import org.apache.seata.core.rpc.netty.http.filter.HttpRequestFilter;
import org.apache.seata.core.rpc.netty.http.filter.HttpRequestFilterChain;

@LoadLevel(name="XSS", order=-2147483648)
public class XSSHttpRequestFilter
implements HttpRequestFilter {
    private static final Configuration CONFIG = ConfigurationFactory.getInstance();
    private static List<String> xssKeywords = DefaultValues.DEFAULT_XSS_KEYWORDS;
    private static final int MAX_EVENT_HANDLER_LENGTH = 50;
    private static final int ON_REPEAT_LIMIT = 5;
    private static final Pattern ON_REPEAT_PATTERN = Pattern.compile("(on){5,}", 2);
    private static final Pattern EVENT_HANDLER_PATTERN = Pattern.compile("\\bon([a-zA-Z0-9]{1,50}?)\\s*=\\s*['\"][^'\"]*['\"]", 2);

    public XSSHttpRequestFilter() {
        String xssKeywordConfig = CONFIG.getConfig("server.http.filter.xss.keywords", null);
        if (StringUtils.isBlank((String)xssKeywordConfig)) {
            return;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            List userCustomKeywords = (List)objectMapper.readValue(xssKeywordConfig, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            LinkedHashSet mergedKeywords = new LinkedHashSet(DefaultValues.DEFAULT_XSS_KEYWORDS);
            if (CollectionUtils.isNotEmpty((Collection)userCustomKeywords)) {
                mergedKeywords.addAll(userCustomKeywords);
            }
            xssKeywords = Collections.unmodifiableList(new ArrayList(mergedKeywords));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid format for configuration 'server.http.filter.xss.keywords'. Expected a JSON array like [\"<script>\", \"vbscript:\"], but got: " + xssKeywordConfig, e);
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void doFilter(HttpFilterContext<?> context, HttpRequestFilterChain chain) throws HttpRequestFilterException {
        Map allParams = context.getParamWrapper().getAllParamsAsMultiMap();
        for (Map.Entry entry : allParams.entrySet()) {
            for (String value : (List)entry.getValue()) {
                if (!this.containsXssRisk(value)) continue;
                throw new HttpRequestFilterException("XSS risk detected in param: " + (String)entry.getKey() + ", value: " + value);
            }
        }
        chain.doFilter(context);
    }

    public boolean shouldApply() {
        return true;
    }

    private boolean containsXssRisk(String value) {
        if (value == null) {
            return false;
        }
        String normalized = value.toLowerCase().replaceAll("\\s+", "");
        for (String keyword : xssKeywords) {
            if (!normalized.contains(keyword)) continue;
            return true;
        }
        if (ON_REPEAT_PATTERN.matcher(value).find()) {
            return true;
        }
        Matcher matcher = EVENT_HANDLER_PATTERN.matcher(value);
        if (matcher.find()) {
            String eventName = matcher.group(1);
            if (eventName.length() > 50) {
                return true;
            }
            return true;
        }
        return false;
    }
}

