/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;

public class CacheQueue {
    private LinkedBlockingQueue queue = null;
    public int maxSize;
    private boolean enableLRU = true;

    public CacheQueue(int n2) {
        this.queue = new LinkedBlockingQueue(n2);
        this.maxSize = n2;
    }

    public CacheQueue(int n2, boolean bl) {
        this.queue = new LinkedBlockingQueue(n2);
        this.maxSize = n2;
        this.enableLRU = bl;
    }

    protected boolean needRemove(Object object) {
        return false;
    }

    protected void beforeRemove(Object object) {
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public synchronized Object get() {
        Object var1_1;
        block4: {
            Object e2;
            block3: {
                var1_1 = null;
                if (!true) break block3;
                e2 = this.queue.poll();
                var1_1 = e2;
                if (e2 == null) break block4;
            }
            do {
                if (!this.needRemove(var1_1)) {
                    return var1_1;
                }
                this.beforeRemove(var1_1);
                e2 = this.queue.poll();
                var1_1 = e2;
            } while (e2 != null);
        }
        return var1_1;
    }

    public synchronized void put(Object object) {
        if (this.queue.contains(object)) {
            return;
        }
        if (this.queue.size() < this.maxSize) {
            this.queue.add(object);
        } else if (this.enableLRU) {
            Object object2 = this.get();
            this.beforeRemove(object2);
            this.queue.add(object);
        } else {
            this.beforeRemove(object);
        }
    }

    public int size() {
        return this.queue.size();
    }

    public synchronized void clear() {
        this.queue.clear();
    }

    public Iterator iterator() {
        return this.queue.iterator();
    }

    public Object clone() {
        CacheQueue cacheQueue = new CacheQueue(this.maxSize, this.enableLRU);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            cacheQueue.put(iterator.next());
        }
        return cacheQueue;
    }
}

