/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasicStructureSerDeUtil {
    public static final int INT_LEN = 4;
    public static final int LONG_LEN = 8;

    private BasicStructureSerDeUtil() {
    }

    public static String readString(ByteBuffer buffer) {
        int strLength = BasicStructureSerDeUtil.readInt(buffer);
        if (strLength < 0) {
            return null;
        }
        if (strLength == 0) {
            return "";
        }
        byte[] bytes = new byte[strLength];
        buffer.get(bytes, 0, strLength);
        return new String(bytes, 0, strLength);
    }

    public static List<String> readStringList(ByteBuffer buffer) {
        int size = BasicStructureSerDeUtil.readInt(buffer);
        if (size < 0) {
            return null;
        }
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            stringList.add(BasicStructureSerDeUtil.readString(buffer));
        }
        return stringList;
    }

    public static int readInt(ByteBuffer buffer) {
        return buffer.getInt();
    }

    public static long readLong(ByteBuffer buffer) {
        return buffer.getLong();
    }

    public static int write(String s, ByteBuffer buffer) {
        if (s == null) {
            return BasicStructureSerDeUtil.write(-1, buffer);
        }
        int len = 0;
        byte[] bytes = s.getBytes();
        len += BasicStructureSerDeUtil.write(bytes.length, buffer);
        buffer.put(bytes);
        return len += bytes.length;
    }

    public static int write(String s, DataOutputStream stream) throws IOException {
        if (s == null) {
            return BasicStructureSerDeUtil.write(-1, stream);
        }
        int len = 0;
        byte[] bytes = s.getBytes();
        len += BasicStructureSerDeUtil.write(bytes.length, stream);
        stream.write(bytes);
        return len += bytes.length;
    }

    public static int write(List<String> stringList, DataOutputStream stream) throws IOException {
        if (stringList == null) {
            throw new IllegalArgumentException("stringList must not be null!");
        }
        int res = 0;
        int size = stringList.size();
        res += BasicStructureSerDeUtil.write(size, stream);
        for (String s : stringList) {
            res += BasicStructureSerDeUtil.write(s, stream);
        }
        return res;
    }

    public static int write(int n, ByteBuffer buffer) {
        buffer.putInt(n);
        return 4;
    }

    public static int write(long n, DataOutputStream stream) throws IOException {
        stream.writeLong(n);
        return 8;
    }

    public static int write(int n, DataOutputStream stream) throws IOException {
        stream.writeInt(n);
        return 4;
    }

    public static int write(Map<String, String> map, ByteBuffer buffer) {
        if (map == null) {
            return BasicStructureSerDeUtil.write(-1, buffer);
        }
        int length = 0;
        buffer.putInt(map.size());
        length += 4;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            byte[] bytes = entry.getKey().getBytes();
            buffer.putInt(bytes.length);
            length += 4;
            buffer.put(bytes);
            length += bytes.length;
            bytes = entry.getValue().getBytes();
            buffer.putInt(bytes.length);
            length += 4;
            buffer.put(bytes);
            length += bytes.length;
        }
        return length;
    }

    public static int write(Map<String, String> map, DataOutputStream stream) throws IOException {
        if (map == null) {
            return BasicStructureSerDeUtil.write(-1, stream);
        }
        int length = 0;
        stream.writeInt(map.size());
        length += 4;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            byte[] bytes = entry.getKey().getBytes();
            stream.writeInt(bytes.length);
            length += 4;
            stream.write(bytes);
            length += bytes.length;
            bytes = entry.getValue().getBytes();
            stream.writeInt(bytes.length);
            length += 4;
            stream.write(bytes);
            length += bytes.length;
        }
        return length;
    }

    public static Map<String, String> readMap(ByteBuffer buffer) {
        int length = BasicStructureSerDeUtil.readInt(buffer);
        if (length == -1) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(length);
        for (int i = 0; i < length; ++i) {
            String key = BasicStructureSerDeUtil.readString(buffer);
            String value = BasicStructureSerDeUtil.readString(buffer);
            map.put(key, value);
        }
        return map;
    }

    public static int writeStringMapLists(Map<String, List<String>> map, ByteBuffer buffer) {
        if (map == null) {
            return BasicStructureSerDeUtil.write(-1, buffer);
        }
        int length = 0;
        buffer.putInt(map.size());
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            byte[] bytes = entry.getKey().getBytes();
            buffer.putInt(bytes.length);
            buffer.put(bytes);
            buffer.putInt(entry.getValue().size());
            entry.getValue().forEach(b -> {
                buffer.putInt(b.length());
                buffer.put(b.getBytes());
            });
        }
        return length;
    }

    public static Map<String, List<String>> readStringMapLists(ByteBuffer buffer) {
        int length = BasicStructureSerDeUtil.readInt(buffer);
        if (length == -1) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(length);
        for (int i = 0; i < length; ++i) {
            String key = BasicStructureSerDeUtil.readString(buffer);
            int listSize = BasicStructureSerDeUtil.readInt(buffer);
            ArrayList<String> valueList = new ArrayList<String>();
            for (int j = 0; j < listSize; ++j) {
                String value = BasicStructureSerDeUtil.readString(buffer);
                valueList.add(value);
            }
            map.put(key, valueList);
        }
        return map;
    }

    public static int writeIntMapLists(Map<Integer, List<Integer>> map, ByteBuffer buffer) {
        if (map == null) {
            return BasicStructureSerDeUtil.write(-1, buffer);
        }
        int length = 0;
        buffer.putInt(map.size());
        for (Map.Entry<Integer, List<Integer>> entry : map.entrySet()) {
            buffer.putInt(entry.getKey());
            buffer.putInt(entry.getValue().size());
            entry.getValue().forEach(buffer::putInt);
        }
        return length;
    }

    public static Map<Integer, List<Integer>> readIntMapLists(ByteBuffer buffer) {
        int length = BasicStructureSerDeUtil.readInt(buffer);
        if (length == -1) {
            return null;
        }
        HashMap<Integer, List<Integer>> map = new HashMap<Integer, List<Integer>>(length);
        for (int i = 0; i < length; ++i) {
            int key = BasicStructureSerDeUtil.readInt(buffer);
            int listSize = BasicStructureSerDeUtil.readInt(buffer);
            ArrayList<Integer> valueList = new ArrayList<Integer>();
            for (int j = 0; j < listSize; ++j) {
                int value = BasicStructureSerDeUtil.readInt(buffer);
                valueList.add(value);
            }
            map.put(key, valueList);
        }
        return map;
    }
}

