/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.property;

public class PipeConsensusClientProperty {
    private final boolean isRpcThriftCompressionEnabled;
    private final int selectorNumOfClientManager;
    private final boolean printLogWhenThriftClientEncounterException;
    private final int maxClientNumForEachNode;

    public PipeConsensusClientProperty(boolean isRpcThriftCompressionEnabled, int selectorNumOfClientManager, boolean printLogWhenThriftClientEncounterException, int maxClientNumForEachNode) {
        this.isRpcThriftCompressionEnabled = isRpcThriftCompressionEnabled;
        this.selectorNumOfClientManager = selectorNumOfClientManager;
        this.printLogWhenThriftClientEncounterException = printLogWhenThriftClientEncounterException;
        this.maxClientNumForEachNode = maxClientNumForEachNode;
    }

    public boolean isRpcThriftCompressionEnabled() {
        return this.isRpcThriftCompressionEnabled;
    }

    public int getSelectorNumOfClientManager() {
        return this.selectorNumOfClientManager;
    }

    public boolean isPrintLogWhenThriftClientEncounterException() {
        return this.printLogWhenThriftClientEncounterException;
    }

    public int getMaxClientNumForEachNode() {
        return this.maxClientNumForEachNode;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private boolean isRpcThriftCompressionEnabled = false;
        private int selectorNumOfClientManager = 1;
        private boolean printLogWhenThriftClientEncounterException = true;
        private int maxClientNumForEachNode = 1000;

        public Builder setIsRpcThriftCompressionEnabled(boolean isRpcThriftCompressionEnabled) {
            this.isRpcThriftCompressionEnabled = isRpcThriftCompressionEnabled;
            return this;
        }

        public Builder setSelectorNumOfClientManager(int selectorNumOfClientManager) {
            this.selectorNumOfClientManager = selectorNumOfClientManager;
            return this;
        }

        public Builder setPrintLogWhenThriftClientEncounterException(boolean printLogWhenThriftClientEncounterException) {
            this.printLogWhenThriftClientEncounterException = printLogWhenThriftClientEncounterException;
            return this;
        }

        public Builder setMaxClientNumForEachNode(int maxClientNumForEachNode) {
            this.maxClientNumForEachNode = maxClientNumForEachNode;
            return this;
        }

        public PipeConsensusClientProperty build() {
            return new PipeConsensusClientProperty(this.isRpcThriftCompressionEnabled, this.selectorNumOfClientManager, this.printLogWhenThriftClientEncounterException, this.maxClientNumForEachNode);
        }
    }
}

