/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task.connection;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePatternOperations;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.ProgressReportEvent;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.source.schemaregion.IoTDBSchemaRegionSource;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeEventCollector
implements EventCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeEventCollector.class);
    private final UnboundedBlockingPendingQueue<Event> pendingQueue;
    private final long creationTime;
    private final int regionId;
    private final boolean forceTabletFormat;
    private final boolean skipParsing;
    private final AtomicInteger collectInvocationCount = new AtomicInteger(0);
    private boolean hasNoGeneratedEvent = true;
    private boolean isFailedToIncreaseReferenceCount = false;

    public PipeEventCollector(UnboundedBlockingPendingQueue<Event> pendingQueue, long creationTime, int regionId, boolean forceTabletFormat, boolean skipParsing) {
        this.pendingQueue = pendingQueue;
        this.creationTime = creationTime;
        this.regionId = regionId;
        this.forceTabletFormat = forceTabletFormat;
        this.skipParsing = skipParsing;
    }

    public void collect(Event event) {
        try {
            if (event instanceof PipeInsertNodeTabletInsertionEvent) {
                this.parseAndCollectEvent((PipeInsertNodeTabletInsertionEvent)event);
            } else if (event instanceof PipeRawTabletInsertionEvent) {
                this.parseAndCollectEvent((PipeRawTabletInsertionEvent)event);
            } else if (event instanceof PipeTsFileInsertionEvent) {
                this.parseAndCollectEvent((PipeTsFileInsertionEvent)event);
            } else if (event instanceof PipeSchemaRegionWritePlanEvent && ((PipeSchemaRegionWritePlanEvent)event).getPlanNode().getType() == PlanNodeType.DELETE_DATA) {
                this.parseAndCollectEvent((PipeSchemaRegionWritePlanEvent)event);
            } else if (!(event instanceof ProgressReportEvent)) {
                this.collectEvent(event);
            }
        }
        catch (PipeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PipeException("Error occurred when collecting events from processor.", (Throwable)e);
        }
    }

    private void parseAndCollectEvent(PipeInsertNodeTabletInsertionEvent sourceEvent) {
        if (this.skipParsing) {
            this.collectEvent((Event)sourceEvent);
            return;
        }
        if (sourceEvent.shouldParseTimeOrPattern()) {
            for (PipeRawTabletInsertionEvent parsedEvent : sourceEvent.toRawTabletInsertionEvents()) {
                this.collectParsedRawTableEvent(parsedEvent);
            }
        } else {
            this.collectEvent((Event)sourceEvent);
        }
    }

    private void parseAndCollectEvent(PipeRawTabletInsertionEvent sourceEvent) {
        if (sourceEvent.shouldParseTimeOrPattern()) {
            this.collectParsedRawTableEvent(sourceEvent.parseEventWithPatternOrTime());
        } else {
            this.collectEvent((Event)sourceEvent);
        }
    }

    private void parseAndCollectEvent(PipeTsFileInsertionEvent sourceEvent) throws Exception {
        if (!sourceEvent.waitForTsFileClose()) {
            LOGGER.warn("Pipe skipping temporary TsFile which shouldn't be transferred: {}", (Object)sourceEvent.getTsFile());
            return;
        }
        if (this.skipParsing || !this.forceTabletFormat && PipeEventCollector.canSkipParsing4TsFileEvent(sourceEvent)) {
            this.collectEvent((Event)sourceEvent);
            return;
        }
        try {
            sourceEvent.consumeTabletInsertionEventsWithRetry(this::collectParsedRawTableEvent, "PipeEventCollector::parseAndCollectEvent");
        }
        finally {
            sourceEvent.close();
        }
    }

    public static boolean canSkipParsing4TsFileEvent(PipeTsFileInsertionEvent sourceEvent) {
        return !sourceEvent.shouldParseTimeOrPattern();
    }

    private void collectParsedRawTableEvent(PipeRawTabletInsertionEvent parsedEvent) {
        if (!parsedEvent.hasNoNeedParsingAndIsEmpty()) {
            this.hasNoGeneratedEvent = false;
            this.collectEvent((Event)parsedEvent);
        }
    }

    private void parseAndCollectEvent(PipeSchemaRegionWritePlanEvent deleteDataEvent) {
        ((Optional)IoTDBSchemaRegionSource.PATTERN_PARSE_VISITOR.process(deleteDataEvent.getPlanNode(), (IoTDBPipePatternOperations)deleteDataEvent.getPipePattern())).map(planNode -> new PipeSchemaRegionWritePlanEvent((PlanNode)planNode, deleteDataEvent.getPipeName(), deleteDataEvent.getCreationTime(), deleteDataEvent.getPipeTaskMeta(), deleteDataEvent.getPipePattern(), deleteDataEvent.isGeneratedByPipe())).ifPresent(event -> {
            this.hasNoGeneratedEvent = false;
            this.collectEvent((Event)event);
        });
    }

    private void collectEvent(Event event) {
        if (event instanceof EnrichedEvent) {
            if (!((EnrichedEvent)event).increaseReferenceCount(PipeEventCollector.class.getName())) {
                LOGGER.warn("PipeEventCollector: The event {} is already released, skipping it.", (Object)event);
                this.isFailedToIncreaseReferenceCount = true;
                return;
            }
            PipeEventCommitManager.getInstance().enrichWithCommitterKeyAndCommitId((EnrichedEvent)event, this.creationTime, this.regionId);
            ((EnrichedEvent)event).setRebootTimes(PipeDataNodeAgent.runtime().getRebootTimes());
        }
        if (event instanceof PipeHeartbeatEvent) {
            ((PipeHeartbeatEvent)event).recordConnectorQueueSize(this.pendingQueue);
        }
        this.pendingQueue.directOffer(event);
        this.collectInvocationCount.incrementAndGet();
    }

    public void resetFlags() {
        this.collectInvocationCount.set(0);
        this.hasNoGeneratedEvent = true;
        this.isFailedToIncreaseReferenceCount = false;
    }

    public long getCollectInvocationCount() {
        return this.collectInvocationCount.get();
    }

    public boolean hasNoCollectInvocationAfterReset() {
        return this.collectInvocationCount.get() == 0;
    }

    public boolean hasNoGeneratedEvent() {
        return this.hasNoGeneratedEvent;
    }

    public boolean isFailedToIncreaseReferenceCount() {
        return this.isFailedToIncreaseReferenceCount;
    }
}

