/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.tsfile;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

public class ImportTsFileScanTool {
    private static final String RESOURCE = ".resource";
    private static final String MODS = ".mods";
    private static final LinkedBlockingQueue<String> tsfileQueue = new LinkedBlockingQueue();
    private static final Set<String> tsfileSet = new HashSet<String>();
    private static final Set<String> resourceOrModsSet = new HashSet<String>();
    private static String sourceFullPath;

    public static void traverseAndCollectFiles() throws InterruptedException {
        ImportTsFileScanTool.traverseAndCollectFilesBySourceFullPath(new File(sourceFullPath));
    }

    private static void traverseAndCollectFilesBySourceFullPath(File file) throws InterruptedException {
        File[] files;
        if (file.isFile()) {
            if (file.getName().endsWith(RESOURCE) || file.getName().endsWith(MODS)) {
                resourceOrModsSet.add(file.getAbsolutePath());
            } else {
                tsfileSet.add(file.getAbsolutePath());
                tsfileQueue.put(file.getAbsolutePath());
            }
        } else if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                ImportTsFileScanTool.traverseAndCollectFilesBySourceFullPath(f);
            }
        }
    }

    public static void addNoResourceOrModsToQueue() throws InterruptedException {
        for (String filePath : resourceOrModsSet) {
            String tsfilePath = filePath.endsWith(RESOURCE) ? filePath.substring(0, filePath.length() - RESOURCE.length()) : filePath.substring(0, filePath.length() - MODS.length());
            if (tsfileSet.contains(tsfilePath)) continue;
            tsfileQueue.put(filePath);
        }
    }

    public static boolean isContainModsFile(String modsFilePath) {
        return resourceOrModsSet.contains(modsFilePath);
    }

    public static String pollFromQueue() {
        return tsfileQueue.poll();
    }

    public static void putToQueue(String filePath) throws InterruptedException {
        tsfileQueue.put(filePath);
    }

    public static void setSourceFullPath(String sourceFullPath) {
        ImportTsFileScanTool.sourceFullPath = sourceFullPath;
    }

    public static int getSourceFullPathLength() {
        return new File(sourceFullPath).isDirectory() ? sourceFullPath.length() : new File(sourceFullPath).getParent().length();
    }

    public static int getTsFileQueueSize() {
        return tsfileQueue.size();
    }
}

