/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;

public class DereferenceExpression
extends Expression {
    private final Expression base;
    @Nullable
    private final Identifier field;

    public DereferenceExpression(Expression base, Identifier field) {
        super(null);
        this.base = Objects.requireNonNull(base, "base is null");
        this.field = Objects.requireNonNull(field, "field is null");
    }

    public DereferenceExpression(NodeLocation location, Expression base, Identifier field) {
        super(Objects.requireNonNull(location, "location is null"));
        this.base = Objects.requireNonNull(base, "base is null");
        this.field = Objects.requireNonNull(field, "field is null");
    }

    public DereferenceExpression(Identifier field) {
        super(null);
        this.base = null;
        this.field = Objects.requireNonNull(field, "field is null");
    }

    public DereferenceExpression(NodeLocation location, Identifier field) {
        super(Objects.requireNonNull(location, "location is null"));
        this.base = null;
        this.field = Objects.requireNonNull(field, "field is null");
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDereferenceExpression(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder children = ImmutableList.builder();
        children.add((Object)this.base);
        if (this.field != null) {
            children.add((Object)this.field);
        }
        return children.build();
    }

    public Expression getBase() {
        return this.base;
    }

    public Optional<Identifier> getField() {
        return Optional.ofNullable(this.field);
    }

    public static QualifiedName getQualifiedName(DereferenceExpression expression) {
        QualifiedName baseQualifiedName;
        if (expression.field == null) {
            return null;
        }
        Identifier field = expression.field;
        ImmutableList parts = null;
        if (expression.base instanceof Identifier) {
            parts = ImmutableList.of((Object)((Identifier)expression.base), (Object)field);
        } else if (expression.base instanceof DereferenceExpression && (baseQualifiedName = DereferenceExpression.getQualifiedName((DereferenceExpression)expression.base)) != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(baseQualifiedName.getOriginalParts());
            builder.add((Object)field);
            parts = builder.build();
        }
        return parts == null ? null : QualifiedName.of((Iterable<Identifier>)parts);
    }

    public static Expression from(QualifiedName name) {
        Expression result = null;
        for (String part : name.getParts()) {
            if (result == null) {
                result = new Identifier(part);
                continue;
            }
            result = new DereferenceExpression(result, new Identifier(part));
        }
        return result;
    }

    public static boolean isQualifiedAllFieldsReference(Expression expression) {
        return expression instanceof DereferenceExpression && ((DereferenceExpression)expression).field == null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DereferenceExpression that = (DereferenceExpression)o;
        return Objects.equals(this.base, that.base) && Objects.equals(this.field, that.field);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.field);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return DereferenceExpression.sameClass(this, other);
    }
}

