/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.tests.optional;

import java.util.Iterator;
import java.util.List;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.comparators.ComparatorUtils;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.mail.SieveMailException;
import org.apache.jsieve.mail.optional.EnvelopeAccessors;
import org.apache.jsieve.tests.AbstractComparatorTest;

public class Envelope
extends AbstractComparatorTest {
    protected List<String> getMatchingValues(MailAdapter mail, String valueName) throws SieveMailException {
        return ((EnvelopeAccessors)((Object)mail)).getMatchingEnvelope(valueName);
    }

    protected boolean match(String addressPart, String comparator, String matchType, String headerValue, String key, SieveContext context) throws SieveException {
        String matchAddress = null;
        if (addressPart.equals(":all")) {
            matchAddress = headerValue;
        } else {
            int localStart = 0;
            int localEnd = 0;
            int domainStart = 0;
            int domainEnd = headerValue.length();
            int splitIndex = headerValue.indexOf(64);
            if (splitIndex == -1) {
                localEnd = domainEnd;
                domainStart = domainEnd;
            } else {
                localEnd = splitIndex;
                domainStart = splitIndex + 1;
            }
            matchAddress = addressPart.equals(":localpart") ? headerValue.substring(localStart, localEnd) : headerValue.substring(domainStart, domainEnd);
        }
        String matchKey = null;
        if (addressPart.equals(":domain")) {
            matchKey = key.toLowerCase();
            matchAddress = matchAddress.toLowerCase();
        } else {
            matchKey = key;
        }
        return ComparatorUtils.match(comparator, matchType, matchAddress, matchKey, context);
    }

    @Override
    protected boolean match(MailAdapter mail, String addressPart, String comparator, String matchType, String headerName, String key, SieveContext context) throws SieveException {
        String value;
        List<String> headerValues = this.getMatchingValues(mail, headerName);
        boolean isMatched = false;
        Iterator<String> iterator = headerValues.iterator();
        while (iterator.hasNext() && !(isMatched = this.match(addressPart, comparator, matchType, value = iterator.next(), key, context))) {
        }
        return isMatched;
    }
}

