/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import jakarta.inject.Inject;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.sieve.cassandra.model.ActiveScriptInfo;
import org.apache.james.sieve.cassandra.tables.CassandraSieveActiveTable;
import org.apache.james.sieverepository.api.ScriptName;
import reactor.core.publisher.Mono;

public class CassandraActiveScriptDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement insertActive;
    private final PreparedStatement deleteActive;
    private final PreparedStatement selectActiveName;

    @Inject
    public CassandraActiveScriptDAO(CqlSession session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.insertActive = session.prepare(QueryBuilder.insertInto((String)"sieve_active").value(CassandraSieveActiveTable.SCRIPT_NAME, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveActiveTable.SCRIPT_NAME)).value(CassandraSieveActiveTable.USER_NAME, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveActiveTable.USER_NAME)).value(CassandraSieveActiveTable.DATE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveActiveTable.DATE)).build());
        this.deleteActive = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"sieve_active").whereColumn(CassandraSieveActiveTable.USER_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveActiveTable.USER_NAME))).build());
        this.selectActiveName = session.prepare(((Select)QueryBuilder.selectFrom((String)"sieve_active").columns(new CqlIdentifier[]{CassandraSieveActiveTable.SCRIPT_NAME, CassandraSieveActiveTable.DATE}).whereColumn(CassandraSieveActiveTable.USER_NAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraSieveActiveTable.USER_NAME))).build());
    }

    public Mono<ActiveScriptInfo> getActiveScriptInfo(Username username) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.selectActiveName.bind(new Object[0]).setString(CassandraSieveActiveTable.USER_NAME, username.asString())).map(row -> new ActiveScriptInfo(new ScriptName(row.getString(CassandraSieveActiveTable.SCRIPT_NAME)), ZonedDateTime.ofInstant(row.getInstant(CassandraSieveActiveTable.DATE), ZoneOffset.UTC)));
    }

    public Mono<Void> unActivate(Username username) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteActive.bind(new Object[0]).setString(CassandraSieveActiveTable.USER_NAME, username.asString()));
    }

    public Mono<Void> activate(Username username, ScriptName scriptName) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.insertActive.bind(new Object[0]).setString(CassandraSieveActiveTable.USER_NAME, username.asString())).setString(CassandraSieveActiveTable.SCRIPT_NAME, scriptName.getValue())).setInstant(CassandraSieveActiveTable.DATE, Instant.now()));
    }
}

