/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail.dao;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.Wildcard;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.apache.james.mailbox.postgres.mail.PostgresACLUpsertException;
import org.apache.james.mailbox.postgres.mail.PostgresMailbox;
import org.apache.james.mailbox.postgres.mail.PostgresMailboxDataDefinition;
import org.apache.james.mailbox.store.MailboxExpressionBackwardCompatibility;
import org.jooq.Condition;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.postgres.extensions.types.Hstore;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresMailboxDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresMailboxDAO.class);
    private static final char SQL_WILDCARD_CHAR = '%';
    private static final Function<MailboxACL, Hstore> MAILBOX_ACL_TO_HSTORE_FUNCTION = acl -> Hstore.hstore(acl.getEntries().entrySet().stream().collect(Collectors.toMap(entry -> ((MailboxACL.EntryKey)entry.getKey()).serialize(), entry -> ((MailboxACL.Rfc4314Rights)entry.getValue()).serialize())));
    private static final Function<Hstore, MailboxACL> HSTORE_TO_MAILBOX_ACL_FUNCTION = hstore -> new MailboxACL((Map)hstore.data().entrySet().stream().map(entry -> PostgresMailboxDAO.deserializeMailboxACLEntry((String)entry.getKey(), (String)entry.getValue())).filter(Optional::isPresent).map(Optional::get).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
    private static final Function<Record, Mailbox> RECORD_TO_MAILBOX_FUNCTION = record -> {
        Mailbox mailbox = new Mailbox(new MailboxPath((String)record.get(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_NAMESPACE), Username.of((String)((String)record.get(PostgresMailboxDataDefinition.PostgresMailboxTable.USER_NAME))), (String)record.get(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_NAME)), UidValidity.of((long)((Long)record.get(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_UID_VALIDITY))), (MailboxId)PostgresMailboxId.of((UUID)record.get(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID)));
        mailbox.setACL(HSTORE_TO_MAILBOX_ACL_FUNCTION.apply(Hstore.hstore((Map)((Map)record.get(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ACL, LinkedHashMap.class)))));
        return mailbox;
    };
    private static final Function<Record, PostgresMailbox> RECORD_TO_POSTGRES_MAILBOX_FUNCTION = record -> new PostgresMailbox(RECORD_TO_MAILBOX_FUNCTION.apply((Record)record), Optional.ofNullable((Long)record.get(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_HIGHEST_MODSEQ)).map(ModSeq::of).orElse(ModSeq.first()), Optional.ofNullable((Long)record.get(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_LAST_UID)).map(MessageUid::of).orElse(null));
    private final PostgresExecutor postgresExecutor;

    private static Optional<Map.Entry<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights>> deserializeMailboxACLEntry(String key, String value) {
        try {
            MailboxACL.EntryKey entryKey = MailboxACL.EntryKey.deserialize((String)key);
            MailboxACL.Rfc4314Rights rfc4314Rights = MailboxACL.Rfc4314Rights.deserialize((String)value);
            return Optional.of(Map.entry(entryKey, rfc4314Rights));
        }
        catch (UnsupportedRightException e) {
            LOGGER.error("Error while deserializing mailbox ACL", (Throwable)e);
            return Optional.empty();
        }
    }

    public PostgresMailboxDAO(PostgresExecutor postgresExecutor) {
        this.postgresExecutor = postgresExecutor;
    }

    public Mono<Mailbox> create(MailboxPath mailboxPath, UidValidity uidValidity) {
        PostgresMailboxId mailboxId = PostgresMailboxId.generate();
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME, PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID, PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_NAME, PostgresMailboxDataDefinition.PostgresMailboxTable.USER_NAME, PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_NAMESPACE, PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_UID_VALIDITY).values((Object)mailboxId.asUuid(), (Object)mailboxPath.getName(), (Object)mailboxPath.getUser().asString(), (Object)mailboxPath.getNamespace(), (Object)uidValidity.asLong()).onConflictOnConstraint(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_NAME_USER_NAME_NAMESPACE_UNIQUE_CONSTRAINT).doNothing().returning(new SelectFieldOrAsterisk[]{PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID}))).map(record -> new Mailbox(mailboxPath, uidValidity, (MailboxId)PostgresMailboxId.of((UUID)record.get(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID)))).switchIfEmpty(Mono.error((Throwable)new MailboxExistsException(mailboxPath.getName())));
    }

    public Mono<MailboxId> rename(Mailbox mailbox) {
        Preconditions.checkNotNull((Object)mailbox.getMailboxId(), (Object)"A mailbox we want to rename should have a defined mailboxId");
        return this.findMailboxByPath(mailbox.generateAssociatedPath()).flatMap(m -> Mono.error((Throwable)new MailboxExistsException(mailbox.getName()))).then(this.update(mailbox));
    }

    private Mono<MailboxId> update(Mailbox mailbox) {
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.update(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME).set(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_NAME, (Object)mailbox.getName()).set(PostgresMailboxDataDefinition.PostgresMailboxTable.USER_NAME, (Object)mailbox.getUser().asString()).set(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_NAMESPACE, (Object)mailbox.getNamespace()).where(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID.eq((Object)((PostgresMailboxId)mailbox.getMailboxId()).asUuid())).returning(new SelectFieldOrAsterisk[]{PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID}))).map(record -> mailbox.getMailboxId()).switchIfEmpty(Mono.error((Throwable)new MailboxNotFoundException(mailbox.getMailboxId())));
    }

    public Mono<Void> upsertACL(MailboxId mailboxId, MailboxACL acl, Long currentAclVersion) {
        return this.postgresExecutor.executeReturnAffectedRowsCount(dslContext -> Mono.from((Publisher)dslContext.update(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME).set(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ACL, (Object)MAILBOX_ACL_TO_HSTORE_FUNCTION.apply(acl)).set(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ACL_VERSION, (Object)(currentAclVersion + 1L)).where(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID.eq((Object)((PostgresMailboxId)mailboxId).asUuid())).and(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ACL_VERSION.eq((Object)currentAclVersion)))).filter(count -> count > 0).switchIfEmpty(Mono.error((Throwable)new PostgresACLUpsertException("Upsert mailbox acl failed with mailboxId " + mailboxId.serialize()))).then();
    }

    public Mono<Void> upsertACL(MailboxId mailboxId, MailboxACL acl) {
        return this.postgresExecutor.executeReturnAffectedRowsCount(dslContext -> Mono.from((Publisher)dslContext.update(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME).set(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ACL, (Object)MAILBOX_ACL_TO_HSTORE_FUNCTION.apply(acl)).set(DSL.field((String)PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ACL_VERSION.getName()), (Object)DSL.field((String)(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ACL_VERSION.getName() + " + 1"))).where(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID.eq((Object)((PostgresMailboxId)mailboxId).asUuid())))).filter(count -> count > 0).switchIfEmpty(Mono.error((Throwable)new RuntimeException("Upsert mailbox acl failed with mailboxId " + mailboxId.serialize()))).then();
    }

    public Mono<Pair<MailboxACL, Long>> getACL(MailboxId mailboxId) {
        return this.postgresExecutor.executeRow(dsl -> Mono.from((Publisher)dsl.select(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ACL, PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ACL_VERSION).from(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME).where(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID.eq((Object)((PostgresMailboxId)mailboxId).asUuid())))).map(record -> Pair.of((Object)Optional.ofNullable((Hstore)record.get(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ACL)).map(HSTORE_TO_MAILBOX_ACL_FUNCTION).orElse(new MailboxACL()), (Object)((Long)record.get(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ACL_VERSION))));
    }

    public Flux<PostgresMailbox> findMailboxesByUsername(Username userName) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID, PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_NAME, PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_UID_VALIDITY, PostgresMailboxDataDefinition.PostgresMailboxTable.USER_NAME, PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_NAMESPACE, PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_LAST_UID, PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_HIGHEST_MODSEQ, (SelectField)DSL.function((String)"slice", (DataType)DefaultDataType.getDefaultDataType((String)"hstore"), (Field[])new Field[]{PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ACL, DSL.array((Field[])new Field[]{DSL.val((String)userName.asString())})}).as(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ACL)).from(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME).where(DSL.sql((String)(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ACL.getName() + " ? '" + userName.asString() + "'"))))).map(RECORD_TO_POSTGRES_MAILBOX_FUNCTION);
    }

    public Mono<Void> delete(MailboxId mailboxId) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME).where(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID.eq((Object)((PostgresMailboxId)mailboxId).asUuid()))));
    }

    public Mono<PostgresMailbox> findMailboxByPath(MailboxPath mailboxPath) {
        return this.postgresExecutor.executeRow(dsl -> Mono.from((Publisher)dsl.selectFrom(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME).where(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_NAME.eq((Object)mailboxPath.getName()).and(PostgresMailboxDataDefinition.PostgresMailboxTable.USER_NAME.eq((Object)mailboxPath.getUser().asString())).and(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_NAMESPACE.eq((Object)mailboxPath.getNamespace()))))).map(RECORD_TO_POSTGRES_MAILBOX_FUNCTION);
    }

    public Mono<PostgresMailbox> findMailboxById(MailboxId id) {
        return this.postgresExecutor.executeRow(dsl -> Mono.from((Publisher)dsl.selectFrom(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME).where(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID.eq((Object)((PostgresMailboxId)id).asUuid())))).map(RECORD_TO_POSTGRES_MAILBOX_FUNCTION).switchIfEmpty(Mono.error((Throwable)new MailboxNotFoundException(id)));
    }

    public Flux<PostgresMailbox> findMailboxByIds(List<PostgresMailboxId> mailboxIds) {
        return this.postgresExecutor.executeRows(dsl -> Flux.from((Publisher)dsl.selectFrom(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME).where(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID.in(mailboxIds.stream().map(PostgresMailboxId::asUuid).toList())))).map(RECORD_TO_POSTGRES_MAILBOX_FUNCTION);
    }

    public Flux<PostgresMailbox> findMailboxWithPathLike(MailboxQuery.UserBound query) {
        String pathLike = MailboxExpressionBackwardCompatibility.getPathLike((MailboxQuery)query);
        Function<MailboxQuery.UserBound, Condition> getQueryCondition = mailboxQuery -> {
            Condition baseCondition = PostgresMailboxDataDefinition.PostgresMailboxTable.USER_NAME.eq((Object)mailboxQuery.getFixedUser().asString()).and(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_NAMESPACE.eq((Object)mailboxQuery.getFixedNamespace()));
            if (Wildcard.INSTANCE.equals((Object)mailboxQuery.getMailboxNameExpression())) {
                return baseCondition;
            }
            return baseCondition.and((Condition)PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_NAME.like(pathLike));
        };
        return this.postgresExecutor.executeRows(dsl -> Flux.from((Publisher)dsl.selectFrom(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME).where((Condition)getQueryCondition.apply(query))), true).map(RECORD_TO_POSTGRES_MAILBOX_FUNCTION).filter(arg_0 -> ((MailboxQuery.UserBound)query).matches(arg_0));
    }

    public Mono<Boolean> hasChildren(Mailbox mailbox, char delimiter) {
        String name = mailbox.getName() + delimiter + "%";
        return this.postgresExecutor.executeExists(dsl -> dsl.selectOne().from(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME).where(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_NAME.like(name).and(PostgresMailboxDataDefinition.PostgresMailboxTable.USER_NAME.eq((Object)mailbox.getUser().asString())).and(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_NAMESPACE.eq((Object)mailbox.getNamespace()))));
    }

    public Flux<PostgresMailbox> getAll() {
        return this.postgresExecutor.executeRows(dsl -> Flux.from((Publisher)dsl.selectFrom(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME))).map(RECORD_TO_POSTGRES_MAILBOX_FUNCTION);
    }

    private UUID asUUID(MailboxId mailboxId) {
        return ((PostgresMailboxId)mailboxId).asUuid();
    }

    public Mono<MessageUid> findLastUidByMailboxId(MailboxId mailboxId) {
        return this.postgresExecutor.executeRow(dsl -> Mono.from((Publisher)dsl.select(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_LAST_UID).from(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME).where(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID.eq((Object)this.asUUID(mailboxId))))).flatMap(record -> Mono.justOrEmpty((Object)((Long)record.get(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_LAST_UID)))).map(MessageUid::of);
    }

    public Mono<MessageUid> incrementAndGetLastUid(MailboxId mailboxId, int count) {
        return this.postgresExecutor.executeRow(dsl -> Mono.from((Publisher)dsl.update(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME).set(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_LAST_UID, DSL.coalesce(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_LAST_UID, (Object)0L).add((Number)count)).where(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID.eq((Object)this.asUUID(mailboxId))).returning(new SelectFieldOrAsterisk[]{PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_LAST_UID}))).map(record -> (Long)record.get(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_LAST_UID)).map(MessageUid::of);
    }

    public Mono<ModSeq> findHighestModSeqByMailboxId(MailboxId mailboxId) {
        return this.postgresExecutor.executeRow(dsl -> Mono.from((Publisher)dsl.select(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_HIGHEST_MODSEQ).from(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME).where(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID.eq((Object)this.asUUID(mailboxId))))).flatMap(record -> Mono.justOrEmpty((Object)((Long)record.get(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_HIGHEST_MODSEQ)))).map(ModSeq::of);
    }

    public Mono<ModSeq> incrementAndGetModSeq(MailboxId mailboxId) {
        return this.postgresExecutor.executeRow(dsl -> Mono.from((Publisher)dsl.update(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME).set(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_HIGHEST_MODSEQ, DSL.coalesce(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_HIGHEST_MODSEQ, (Object)0L).add((Number)1)).where(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID.eq((Object)this.asUUID(mailboxId))).returning(new SelectFieldOrAsterisk[]{PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_HIGHEST_MODSEQ}))).map(record -> (Long)record.get(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_HIGHEST_MODSEQ)).map(ModSeq::of);
    }

    public Mono<Pair<MessageUid, ModSeq>> incrementAndGetLastUidAndModSeq(MailboxId mailboxId) {
        int increment = 1;
        return this.postgresExecutor.executeRow(dsl -> Mono.from((Publisher)dsl.update(PostgresMailboxDataDefinition.PostgresMailboxTable.TABLE_NAME).set(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_LAST_UID, DSL.coalesce(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_LAST_UID, (Object)0L).add((Number)increment)).set(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_HIGHEST_MODSEQ, DSL.coalesce(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_HIGHEST_MODSEQ, (Object)0L).add((Number)increment)).where(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_ID.eq((Object)this.asUUID(mailboxId))).returning(new SelectFieldOrAsterisk[]{PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_LAST_UID, PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_HIGHEST_MODSEQ}))).map(record -> Pair.of((Object)MessageUid.of((long)((Long)record.get(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_LAST_UID))), (Object)ModSeq.of((long)((Long)record.get(PostgresMailboxDataDefinition.PostgresMailboxTable.MAILBOX_HIGHEST_MODSEQ)))));
    }
}

