/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.sys;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shex.ShexRecord;
import org.apache.jena.shex.ShexReport;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.ShexShape;
import org.apache.jena.shex.ShexStatus;
import org.apache.jena.shex.expressions.SemAct;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.expressions.TripleExpression;
import org.apache.jena.shex.semact.SemanticActionPlugin;
import org.apache.jena.shex.sys.ReportItem;

public class ValidationContext {
    private final ShexSchema shapes;
    private final Graph data;
    private boolean verbose = false;
    private boolean seenReportEntry = false;
    private ValidationContext parentCtx = null;
    private Map<String, SemanticActionPlugin> semActPluginIndex;
    private Deque<Pair<Node, ShexShape>> inProgress = new ArrayDeque<Pair<Node, ShexShape>>();
    private final ShexReport.Builder reportBuilder = ShexReport.create();

    public ValidationContext(Graph data, ShexSchema shapes) {
        this(data, shapes, null);
    }

    private ValidationContext(ValidationContext vCxt) {
        this(vCxt, vCxt.data, vCxt.shapes, vCxt.inProgress, vCxt.semActPluginIndex);
    }

    public ValidationContext(Graph data, ShexSchema shapes, Map<String, SemanticActionPlugin> semActPluginIndex) {
        this(null, data, shapes, null, semActPluginIndex);
    }

    private ValidationContext(ValidationContext parentCtx, Graph data, ShexSchema shapes, Deque<Pair<Node, ShexShape>> progress, Map<String, SemanticActionPlugin> semActPluginIndex) {
        this.parentCtx = parentCtx;
        this.data = data;
        this.shapes = shapes;
        this.semActPluginIndex = semActPluginIndex;
        if (progress != null) {
            this.inProgress.addAll(progress);
        }
    }

    public ValidationContext getParent() {
        return this.parentCtx;
    }

    public ValidationContext getRoot() {
        ValidationContext parent = this.parentCtx;
        while (parent != null) {
            parent = this.getParent();
        }
        return parent != null ? parent : this;
    }

    public TripleExpression getTripleExpression(Node label) {
        return this.shapes.getTripleExpression(label);
    }

    public ShexSchema getShapes() {
        return this.shapes;
    }

    public ShexShape getShape(Node label) {
        return this.shapes.get(label);
    }

    public Graph getData() {
        return this.data;
    }

    public ValidationContext create() {
        return new ValidationContext(this, this.data, this.shapes, this.inProgress, this.semActPluginIndex);
    }

    public void startValidate(ShexShape shape, Node data) {
        this.inProgress.push((Pair<Node, ShexShape>)Pair.create((Object)data, (Object)shape));
    }

    public boolean cycle(ShexShape shape, Node data) {
        return this.inProgress.stream().anyMatch(p -> p.equalElts((Object)data, (Object)shape));
    }

    public boolean dispatchStartSemanticAction(ShexSchema schema, ValidationContext vCxt) {
        return !schema.getSemActs().stream().anyMatch(semAct -> {
            String semActIri = semAct.getIri();
            SemanticActionPlugin semActPlugin = this.semActPluginIndex.get(semActIri);
            if (semActPlugin != null && !semActPlugin.evaluateStart((SemAct)semAct, schema)) {
                vCxt.reportEntry(new ReportItem(String.format("%s start shape failed", semActIri), null));
                return true;
            }
            return false;
        });
    }

    public boolean dispatchShapeExprSemanticAction(ShapeExpression se, Node focus) {
        return !se.getSemActs().stream().anyMatch(semAct -> {
            SemanticActionPlugin semActPlugin = this.semActPluginIndex.get(semAct.getIri());
            return semActPlugin != null && !semActPlugin.evaluateShapeExpr((SemAct)semAct, se, focus);
        });
    }

    public boolean dispatchTripleExprSemanticAction(TripleExpression te, Set<Triple> matchables) {
        return !te.getSemActs().stream().anyMatch(semAct -> {
            SemanticActionPlugin semActPlugin = this.semActPluginIndex.get(semAct.getIri());
            return semActPlugin != null && !semActPlugin.evaluateTripleExpr((SemAct)semAct, te, (Collection<Triple>)matchables);
        });
    }

    public void finishValidate(ShexShape shape, Node data) {
        Pair<Node, ShexShape> x = this.inProgress.pop();
        if (x.equalElts((Object)data, (Object)shape)) {
            return;
        }
        throw new InternalErrorException("Eval stack error");
    }

    public boolean hasEntries() {
        return this.reportBuilder.hasEntries();
    }

    public void copyInto(ValidationContext other) {
        this.reportBuilder.getItems().forEach(item -> other.reportEntry((ReportItem)item));
        this.reportBuilder.getReports().forEach(reportLine -> other.shexReport((ShexRecord)reportLine));
    }

    private void shexReport(ShexRecord reportLine) {
        this.reportBuilder.shexReport(reportLine);
    }

    public List<ReportItem> getReportItems() {
        return this.reportBuilder.getItems();
    }

    public List<ShexRecord> getShexReportItems() {
        return this.reportBuilder.getReports();
    }

    public void reportEntry(ReportItem item) {
        this.reportBuilder.addReportItem(item);
    }

    public void shexReport(ShexRecord entry, Node focusNode, ShexStatus result, String reason) {
        this.reportBuilder.shexReport(entry, focusNode, result, reason);
    }

    public ShexReport generateReport() {
        return this.reportBuilder.build();
    }
}

