/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.CmdARQ;
import arq.cmdline.ModQueryIn;
import arq.cmdline.ModRemote;
import arq.cmdline.ModResultsOut;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.query.Query;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.engine.http.QueryExceptionHTTP;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTP;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTPBuilder;
import org.apache.jena.sparql.exec.http.QuerySendMode;
import org.apache.jena.sparql.util.QueryExecUtils;

public class rsparql
extends CmdARQ {
    protected ModQueryIn modQuery = new ModQueryIn(Syntax.syntaxARQ);
    protected ModRemote modRemote = new ModRemote();
    protected ModResultsOut modResults = new ModResultsOut();

    public static void main(String ... argv) {
        new rsparql(argv).mainRun();
    }

    public rsparql(String[] argv) {
        super(argv);
        super.addModule(this.modRemote);
        super.addModule(this.modQuery);
        super.addModule(this.modResults);
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (this.modRemote.getServiceURL() == null) {
            throw new CmdException("No SPARQL endpoint specificied");
        }
    }

    @Override
    protected void exec() {
        Query query2 = this.modQuery.getQuery();
        try {
            String serviceURL = this.modRemote.getServiceURL();
            QuerySendMode sendMode = this.modRemote.usePost() ? QuerySendMode.asPost : QuerySendMode.systemDefault;
            QueryExecutionHTTP qe = (QueryExecutionHTTP)((QueryExecutionHTTPBuilder)((QueryExecutionHTTPBuilder)((QueryExecutionHTTPBuilder)QueryExecutionHTTPBuilder.create().endpoint(serviceURL)).query(query2)).sendMode(sendMode)).build();
            QueryExecUtils.executeQuery(query2, qe, this.modResults.getResultsFormat());
        }
        catch (QueryExceptionHTTP ex) {
            throw new CmdException("HTTP Exception", ex);
        }
        catch (Exception ex) {
            System.out.flush();
            ex.printStackTrace(System.err);
        }
    }

    @Override
    protected String getSummary() {
        return "rsparql --service URL [--results FORMAT] [--query FILENAME | QueyString ]";
    }
}

